/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.AnnotationAttachPoint;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeDescTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.TypeCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.FieldAccessCompletionResolver;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;

public class AnnotationAccessExpressionNodeContext
extends AbstractCompletionProvider<AnnotAccessExpressionNode> {
    public AnnotationAccessExpressionNodeContext() {
        super(AnnotAccessExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, AnnotAccessExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        FieldAccessCompletionResolver fieldAccessCompletionResolver = new FieldAccessCompletionResolver((PositionedOperationContext)context);
        Optional type = (Optional)node.expression().apply((NodeTransformer)fieldAccessCompletionResolver);
        if (type.isEmpty() || ((TypeSymbol)type.get()).typeKind() != TypeDescKind.TYPEDESC || ((TypeDescTypeSymbol)type.get()).typeParameter().isEmpty()) {
            return completionItems;
        }
        return this.getAnnotationTags(context, node, (TypeSymbol)type.get());
    }

    private List<LSCompletionItem> getAnnotationTags(BallerinaCompletionContext context, AnnotAccessExpressionNode node, TypeSymbol typeSymbol) {
        boolean isTypeDescKindAnyOrAnyData;
        TypeDescKind typeDescKind = ((TypeSymbol)((TypeDescTypeSymbol)typeSymbol).typeParameter().get()).typeKind();
        List<AnnotationAttachPoint> attachPointsForType = this.getAttachPointsForType(typeSymbol);
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        boolean bl = isTypeDescKindAnyOrAnyData = typeDescKind == TypeDescKind.ANY || typeDescKind == TypeDescKind.ANYDATA;
        if (attachPointsForType.isEmpty() && !isTypeDescKindAnyOrAnyData) {
            return Collections.emptyList();
        }
        List<AnnotationSymbol> annotationSymbols = AnnotationAccessExpressionNodeContext.getAnnotationEntries(context);
        annotationSymbols.forEach(annotationSymbol -> {
            List annotationAttachPoints = annotationSymbol.attachPoints();
            for (AnnotationAttachPoint ap : attachPointsForType) {
                if (!annotationAttachPoints.isEmpty() && !annotationAttachPoints.contains(ap)) continue;
                completionItems.add(this.getAnnotationsCompletionItem(context, (AnnotationSymbol)annotationSymbol));
                break;
            }
        });
        if (!QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private List<AnnotationAttachPoint> getAttachPointsForType(TypeSymbol typeSymbol) {
        if (((TypeDescTypeSymbol)typeSymbol).typeParameter().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationAttachPoint> annotationAttachPoints = new ArrayList<AnnotationAttachPoint>();
        TypeSymbol symbol = (TypeSymbol)((TypeDescTypeSymbol)typeSymbol).typeParameter().get();
        switch (symbol.typeKind()) {
            case TYPEDESC: {
                TypeDescTypeSymbol typeDescTypeSymbol = (TypeDescTypeSymbol)symbol;
                if (((TypeReferenceTypeSymbol)typeDescTypeSymbol.typeParameter().get()).typeDescriptor().kind() == SymbolKind.CLASS) {
                    annotationAttachPoints.add(AnnotationAttachPoint.CLASS);
                    break;
                }
                annotationAttachPoints.add(AnnotationAttachPoint.TYPE);
                break;
            }
            case OBJECT: {
                if (((ObjectTypeSymbol)symbol).qualifiers().contains(Qualifier.SERVICE)) {
                    annotationAttachPoints.add(AnnotationAttachPoint.SERVICE);
                    break;
                }
                annotationAttachPoints.add(AnnotationAttachPoint.CLASS);
                break;
            }
            case FUNCTION: {
                annotationAttachPoints.add(AnnotationAttachPoint.FUNCTION);
                annotationAttachPoints.add(AnnotationAttachPoint.TYPE);
                break;
            }
            case RECORD: {
                annotationAttachPoints.add(AnnotationAttachPoint.TYPE);
                break;
            }
            case UNION: {
                List<TypeDescKind> typeDescKinds = ((UnionTypeSymbol)symbol).memberTypeDescriptors().stream().map(TypeSymbol::typeKind).toList();
                if (!typeDescKinds.contains(TypeDescKind.ANY) && typeDescKinds.contains(TypeDescKind.ANYDATA)) break;
                annotationAttachPoints.addAll(Arrays.asList(AnnotationAttachPoint.TYPE, AnnotationAttachPoint.CLASS, AnnotationAttachPoint.FUNCTION, AnnotationAttachPoint.SERVICE));
                break;
            }
            case ANY: 
            case ANYDATA: {
                annotationAttachPoints.addAll(Arrays.asList(AnnotationAttachPoint.TYPE, AnnotationAttachPoint.CLASS, AnnotationAttachPoint.FUNCTION, AnnotationAttachPoint.SERVICE));
                break;
            }
        }
        return annotationAttachPoints;
    }

    private static List<AnnotationSymbol> getAnnotationEntries(BallerinaCompletionContext ctx) {
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.ANNOTATION;
        List<AnnotationSymbol> annotationSymbols = QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor) ? QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)ctx, (QualifiedNameReferenceNode)nodeAtCursor, predicate).stream().map(symbol -> (AnnotationSymbol)symbol).toList() : ctx.visibleSymbols(ctx.getCursorPosition()).stream().filter(predicate).map(symbol -> (AnnotationSymbol)symbol).toList();
        return annotationSymbols;
    }

    private LSCompletionItem getAnnotationsCompletionItem(BallerinaCompletionContext ctx, AnnotationSymbol annotationSymbol) {
        CompletionItem item = new CompletionItem();
        item.setInsertText((String)annotationSymbol.getName().get());
        item.setLabel((String)annotationSymbol.getName().get());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setDetail("Annotation");
        item.setKind(CompletionItemKind.Property);
        return new TypeCompletionItem(ctx, null, item);
    }

    @Override
    protected List<LSCompletionItem> getPredeclaredLangLibCompletions(BallerinaCompletionContext context) {
        return Collections.emptyList();
    }

    @Override
    public void sort(BallerinaCompletionContext context, AnnotAccessExpressionNode node, List<LSCompletionItem> lsCItems) {
        for (LSCompletionItem lsCItem : lsCItems) {
            CompletionItem completionItem = lsCItem.getCompletionItem();
            if (completionItem.getDetail().equals("Annotation")) {
                completionItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
                continue;
            }
            completionItem.setSortText(SortingUtil.genSortText(2) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
        }
    }
}

