/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationAttachPoint;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.AnnotationUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class AnnotationNodeContext
extends AbstractCompletionProvider<AnnotationNode> {
    private static final String DIAGNOSTIC_CODE_ANNOTATION_NOT_ATTACHED = "BCE0524";

    public AnnotationNodeContext() {
        super(AnnotationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, AnnotationNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Node attachedNode = this.getAttached(node);
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, node.annotReference())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)node.annotReference();
            completionItems.addAll(this.getAnnotationsInModule(context, qNameRef.modulePrefix().text(), node, attachedNode));
        } else {
            completionItems.addAll(this.getModuleCompletionItems(context));
            completionItems.addAll(this.getCurrentModuleAnnotations(context, node, attachedNode));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private List<LSCompletionItem> getCurrentModuleAnnotations(BallerinaCompletionContext ctx, AnnotationNode annotationNode, Node attachedNode) {
        List visibleSymbols = ctx.visibleSymbols(ctx.getCursorPosition());
        return visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.ANNOTATION && this.matchingAnnotation((AnnotationSymbol)symbol, annotationNode, attachedNode, ctx)).map(symbol -> AnnotationUtil.getAnnotationItem((AnnotationSymbol)symbol, ctx)).toList();
    }

    private List<LSCompletionItem> getAnnotationsInModule(BallerinaCompletionContext context, String alias, AnnotationNode annotationNode, Node attachedNode) {
        Optional<ModuleSymbol> moduleEntry = ModuleUtil.searchModuleForAlias((PositionedOperationContext)context, alias);
        return moduleEntry.orElseThrow().allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.ANNOTATION && this.matchingAnnotation((AnnotationSymbol)symbol, annotationNode, attachedNode, context)).map(symbol -> AnnotationUtil.getAnnotationItem((AnnotationSymbol)symbol, context)).toList();
    }

    private Node getAttached(AnnotationNode node) {
        if (node.parent().kind() == SyntaxKind.METADATA) {
            return node.parent().parent();
        }
        return node.parent();
    }

    private boolean matchingAnnotation(AnnotationSymbol symbol, AnnotationNode annotationNode, Node attachedNode, BallerinaCompletionContext context) {
        if (symbol.attachPoints().isEmpty()) {
            return true;
        }
        for (Diagnostic diagnostic : annotationNode.diagnostics()) {
            if (!DIAGNOSTIC_CODE_ANNOTATION_NOT_ATTACHED.equals(diagnostic.diagnosticInfo().code())) continue;
            return true;
        }
        return switch (attachedNode.kind()) {
            case SyntaxKind.SERVICE_DECLARATION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.SERVICE);
            case SyntaxKind.EXPLICIT_ANONYMOUS_FUNCTION_EXPRESSION, SyntaxKind.IMPLICIT_ANONYMOUS_FUNCTION_EXPRESSION, SyntaxKind.FUNCTION_DEFINITION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.FUNCTION);
            case SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, SyntaxKind.METHOD_DECLARATION, SyntaxKind.OBJECT_METHOD_DEFINITION -> {
                if (AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.FUNCTION) || AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.OBJECT_METHOD)) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.LISTENER_DECLARATION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.LISTENER);
            case SyntaxKind.NAMED_WORKER_DECLARATION, SyntaxKind.START_ACTION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.WORKER);
            case SyntaxKind.CONST_DECLARATION, SyntaxKind.ENUM_MEMBER -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.CONST);
            case SyntaxKind.ENUM_DECLARATION, SyntaxKind.TYPE_CAST_PARAM, SyntaxKind.TYPE_DEFINITION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.TYPE);
            case SyntaxKind.CLASS_DEFINITION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.CLASS);
            case SyntaxKind.RETURN_TYPE_DESCRIPTOR -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.RETURN);
            case SyntaxKind.OBJECT_FIELD -> {
                if (AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.FIELD) || AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.OBJECT_FIELD)) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.RECORD_FIELD, SyntaxKind.RECORD_FIELD_WITH_DEFAULT_VALUE -> {
                if (AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.FIELD) || AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.RECORD_FIELD)) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.MODULE_VAR_DECL, SyntaxKind.LOCAL_VAR_DECL, SyntaxKind.LET_VAR_DECL -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.VAR);
            case SyntaxKind.EXTERNAL_FUNCTION_BODY -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.EXTERNAL);
            case SyntaxKind.ANNOTATION_DECLARATION -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.ANNOTATION);
            case SyntaxKind.REQUIRED_PARAM, SyntaxKind.DEFAULTABLE_PARAM, SyntaxKind.REST_PARAM -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.PARAMETER);
            case SyntaxKind.OBJECT_CONSTRUCTOR -> {
                if (AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.SERVICE) && ((ObjectConstructorExpressionNode)attachedNode).objectTypeQualifiers().stream().anyMatch(token -> token.kind() == SyntaxKind.SERVICE_KEYWORD)) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.MEMBER_TYPE_DESC -> AnnotationUtil.hasAttachment(symbol, AnnotationAttachPoint.FIELD);
            default -> false;
        };
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, AnnotationNode node) {
        return !node.atToken().isMissing() && context.getCursorPositionInTree() <= node.annotReference().textRange().endOffset();
    }

    private boolean addAlias(BallerinaCompletionContext context, AnnotationNode node, ModuleID annotationOwner) {
        Optional currentModule = context.workspace().module(context.filePath());
        if (currentModule.isEmpty()) {
            return false;
        }
        String orgName = annotationOwner.orgName();
        String value = annotationOwner.moduleName();
        return node.annotReference().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE && !((Module)currentModule.get()).moduleName().moduleNamePart().equals(annotationOwner.moduleName()) && (!"ballerina".equals(orgName) || !"lang.annotations".equals(value));
    }

    @Override
    public void sort(BallerinaCompletionContext context, AnnotationNode node, List<LSCompletionItem> completionItems) {
        completionItems.forEach(completionItem -> {
            int rank;
            if (completionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL) {
                Optional<Symbol> symbol = ((SymbolCompletionItem)((Object)completionItem)).getSymbol();
                if (symbol.isPresent() && symbol.get().kind() == SymbolKind.ANNOTATION) {
                    Optional currentProject = context.workspace().project(context.filePath());
                    String currentOrg = ((Project)currentProject.get()).currentPackage().packageOrg().value();
                    String currentPkgName = ((Project)currentProject.get()).currentPackage().packageName().value();
                    Optional symbolModule = symbol.get().getModule();
                    String orgName = symbolModule.isPresent() ? ((ModuleSymbol)symbolModule.get()).id().orgName() : "";
                    String moduleName = symbolModule.isPresent() ? ((ModuleSymbol)symbolModule.get()).id().moduleName() : "";
                    rank = currentOrg.equals(orgName) && currentPkgName.equals(moduleName) ? 1 : 2;
                } else {
                    rank = SortingUtil.toRank(context, completionItem, 2);
                }
            } else {
                rank = SortingUtil.toRank(context, completionItem, 2);
            }
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank));
        });
    }
}

