/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class ArrayTypeDescriptorNodeContext
extends AbstractCompletionProvider<ArrayTypeDescriptorNode> {
    public ArrayTypeDescriptorNodeContext() {
        super(ArrayTypeDescriptorNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ArrayTypeDescriptorNode node) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qName = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleConstants = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qName, this.constantFilter());
            completionItems.addAll(this.getCompletionItemList(moduleConstants, context));
        } else {
            List<Symbol> constants = visibleSymbols.stream().filter(this.constantFilter()).toList();
            completionItems.addAll(this.getModuleCompletionItems(context));
            completionItems.addAll(this.getCompletionItemList(constants, context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private Predicate<Symbol> constantFilter() {
        return symbol -> {
            if (symbol.kind() != SymbolKind.CONSTANT) {
                return false;
            }
            TypeSymbol constExprType = ((ConstantSymbol)symbol).broaderTypeDescriptor();
            return constExprType != null && constExprType.typeKind().isIntegerType();
        };
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ArrayTypeDescriptorNode node) {
        int cursor = context.getCursorPositionInTree();
        for (ArrayDimensionNode arrayDimension : node.dimensions()) {
            Token openBracket = arrayDimension.openBracket();
            Token closeBracket = arrayDimension.closeBracket();
            if (cursor <= openBracket.textRange().startOffset()) break;
            if (cursor >= closeBracket.textRange().endOffset()) continue;
            return true;
        }
        return false;
    }
}

