/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.NamedPathSegment;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.builder.ResourcePathCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.ResourcePathCompletionUtil;
import org.ballerinalang.langserver.completions.providers.context.RightArrowActionNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public class ClientResourceAccessActionNodeContext
extends RightArrowActionNodeContext<ClientResourceAccessActionNode> {
    public ClientResourceAccessActionNodeContext() {
        super(ClientResourceAccessActionNode.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ClientResourceAccessActionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestClients(node, context)) {
            completionItems.addAll(this.expressionCompletions(context));
            this.sort(context, node, (List<LSCompletionItem>)completionItems);
            return completionItems;
        }
        LinePosition linePosition = node.expression().location().lineRange().endLine();
        Optional expressionType = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            expressionType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (expressionType.isEmpty() || !SymbolUtil.isClient((Symbol)expressionType.get())) {
            return Collections.emptyList();
        }
        if (this.isInResourceMethodParameterContext(node, context)) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
                List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
                List<LSCompletionItem> items = this.getCompletionItemList(exprEntries, context);
                completionItems.addAll(items);
            } else {
                ArrayList arguments = new ArrayList();
                node.arguments().ifPresent(argList -> arguments.addAll(argList.arguments().stream().toList()));
                if (this.isNotInNamedArgOnlyContext(context, arguments)) {
                    completionItems.addAll(this.actionKWCompletions(context));
                    completionItems.addAll(this.expressionCompletions(context));
                }
                completionItems.addAll(this.getNamedArgExpressionCompletionItems(context, node));
            }
        } else {
            List<Node> resourcePathSegments;
            List<MethodSymbol> clientActions = this.getClientActions((Symbol)expressionType.get());
            List<ResourceMethodSymbol> resourceMethodSymbols = clientActions.stream().filter(symbol -> symbol.kind() == SymbolKind.RESOURCE_METHOD).map(symbol -> (ResourceMethodSymbol)symbol).toList();
            List<MethodSymbol> remoteMethods = clientActions.stream().filter(symbol -> symbol.kind() == SymbolKind.METHOD && symbol.qualifiers().contains(Qualifier.REMOTE)).toList();
            if (node.slashToken().isMissing()) {
                completionItems.addAll(this.getCompletionItemList(remoteMethods, context));
            }
            if (!(resourcePathSegments = ClientResourceAccessActionNodeContext.getResourcePathSegments(node, context)).isEmpty() || ResourcePathCompletionUtil.isInMethodCallContext(node, context)) {
                completionItems.addAll(this.getPathSegmentCompletionItems(node, context, resourceMethodSymbols, resourcePathSegments));
            } else if (!ResourcePathCompletionUtil.isInMethodCallContext(node, context)) {
                completionItems.addAll(this.getCompletionItemList(resourceMethodSymbols, context));
            }
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private static List<Node> getResourcePathSegments(ClientResourceAccessActionNode node, BallerinaCompletionContext context) {
        ArrayList<Node> resourcePathSegments = new ArrayList<Node>();
        SeparatedNodeList resourcePath = node.resourceAccessPath();
        Iterator iterator = resourcePath.iterator();
        int separatorIndex = 0;
        while (iterator.hasNext()) {
            Token separator;
            Node segment = (Node)iterator.next();
            if (segment.isMissing()) continue;
            if (segment.lineRange().startLine().line() > context.getCursorPositionInTree()) break;
            resourcePathSegments.add(segment);
            if (ClientResourceAccessActionNodeContext.hasTrailingNewLineMinutiae(segment) || resourcePath.separatorSize() > separatorIndex && (separator = resourcePath.getSeparator(separatorIndex)).lineRange().startLine().line() <= context.getCursorPositionInTree() && ClientResourceAccessActionNodeContext.hasTrailingNewLineMinutiae((Node)separator)) break;
            ++separatorIndex;
        }
        return resourcePathSegments;
    }

    private static boolean hasTrailingNewLineMinutiae(Node segment) {
        return !segment.trailingMinutiae().isEmpty() && StreamSupport.stream(segment.trailingMinutiae().spliterator(), false).anyMatch(minutiae -> minutiae.kind() == SyntaxKind.END_OF_LINE_MINUTIAE);
    }

    @Override
    public void sort(BallerinaCompletionContext context, ClientResourceAccessActionNode node, List<LSCompletionItem> completionItems) {
        if (this.onSuggestClients(node, context)) {
            completionItems.forEach(completionItem -> {
                Optional<TypeSymbol> typeSymbol = SortingUtil.getSymbolFromCompletionItem(completionItem);
                Object sortText = typeSymbol.isPresent() && SymbolUtil.isClient((Symbol)typeSymbol.get()) ? SortingUtil.genSortText(1) : SortingUtil.genSortText(2);
                sortText = (String)sortText + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
                completionItem.getCompletionItem().setSortText((String)sortText);
            });
            return;
        }
        Optional<TypeSymbol> parameterSymbol = ClientResourceAccessActionNodeContext.getParameterTypeSymbol(context);
        for (int i = 0; i < completionItems.size(); ++i) {
            LSCompletionItem completionItem2 = completionItems.get(i);
            LSCompletionItem.CompletionItemType type = completionItem2.getType();
            if (type == LSCompletionItem.CompletionItemType.NAMED_ARG) {
                ClientResourceAccessActionNodeContext.sortNamedArgCompletionItem(context, completionItem2);
                continue;
            }
            if (parameterSymbol.isEmpty()) {
                ClientResourceAccessActionNodeContext.sortParameterlessCompletionItem(context, i, completionItem2);
                continue;
            }
            if (type == LSCompletionItem.CompletionItemType.SYMBOL) {
                ClientResourceAccessActionNodeContext.sortSymbolCompletionItem(context, parameterSymbol.get(), i, completionItem2);
                continue;
            }
            ClientResourceAccessActionNodeContext.sortDefaultCompletionItem(context, parameterSymbol.get(), completionItem2);
        }
    }

    private static void sortParameterlessCompletionItem(BallerinaCompletionContext context, int rank, LSCompletionItem completionItem) {
        completionItem.getCompletionItem().setSortText(SortingUtil.genSortText(SortingUtil.toRank(context, completionItem)) + SortingUtil.genSortText(rank + 1));
    }

    private static void sortSymbolCompletionItem(BallerinaCompletionContext context, TypeSymbol parameterSymbol, int rank, LSCompletionItem completionItem) {
        SymbolCompletionItem symbolCompletionItem = (SymbolCompletionItem)completionItem;
        Optional<Symbol> symbol = symbolCompletionItem.getSymbol();
        if (symbol.isPresent() && symbol.get().kind() == SymbolKind.RESOURCE_METHOD) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, parameterSymbol) + SortingUtil.genSortText(rank + 1));
            return;
        }
        ClientResourceAccessActionNodeContext.sortDefaultCompletionItem(context, parameterSymbol, completionItem);
    }

    private List<LSCompletionItem> getPathSegmentCompletionItems(ClientResourceAccessActionNode node, BallerinaCompletionContext context, List<ResourceMethodSymbol> resourceMethods, List<Node> resourcePathSegments) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        for (ResourceMethodSymbol resourceMethod : resourceMethods) {
            List<Object> segments;
            ResourcePath resourcePath = resourceMethod.resourcePath();
            if (resourcePath.kind() == ResourcePath.Kind.PATH_SEGMENT_LIST) {
                segments = ((PathSegmentList)resourcePath).list();
            } else if (resourcePath.kind() == ResourcePath.Kind.PATH_REST_PARAM) {
                PathParameterSymbol parameterSymbol = ((PathRestParam)resourcePath).parameter();
                segments = List.of(parameterSymbol);
            } else {
                segments = new ArrayList<PathSegment>();
            }
            Pair<List<PathSegment>, Boolean> completablePathSegments = this.completableSegmentList(resourceMethod, segments, resourcePathSegments, context, node);
            if (((Boolean)completablePathSegments.getRight()).booleanValue() && !((List)completablePathSegments.getLeft()).isEmpty()) {
                List<CompletionItem> items = ResourcePathCompletionItemBuilder.build(resourceMethod, (List)completablePathSegments.getLeft(), context);
                items.stream().map(completionItem -> new SymbolCompletionItem(context, (Symbol)resourceMethod, (CompletionItem)completionItem)).forEach(completionItems::add);
                continue;
            }
            if (!((Boolean)completablePathSegments.getRight()).booleanValue() || !ResourcePathCompletionUtil.isInMethodCallContext(node, context) || this.isGetMethodWithoutParams(resourceMethod)) continue;
            CompletionItem completionItem2 = ResourcePathCompletionItemBuilder.buildMethodCallExpression(resourceMethod, context);
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)resourceMethod, completionItem2));
        }
        return completionItems;
    }

    private Pair<List<PathSegment>, Boolean> completableSegmentList(ResourceMethodSymbol resourceMethodSymbol, List<PathSegment> segments, List<Node> currentSegments, BallerinaCompletionContext context, ClientResourceAccessActionNode accNode) {
        Optional<PathSegment> pathRestParam = segments.stream().filter(pathSegment -> pathSegment.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER).findFirst();
        if (segments.size() < currentSegments.size() && pathRestParam.isEmpty()) {
            return Pair.of(Collections.emptyList(), (Object)false);
        }
        if (currentSegments.isEmpty() && ResourcePathCompletionUtil.isInMethodCallContext(accNode, context)) {
            return Pair.of(Collections.emptyList(), (Object)(resourceMethodSymbol.resourcePath().kind() == ResourcePath.Kind.DOT_RESOURCE_PATH ? 1 : 0));
        }
        int completableSegmentStartIndex = 0;
        int numOfProvidedSegments = currentSegments.size();
        for (int i = 0; i < numOfProvidedSegments; ++i) {
            PathSegment segment;
            ++completableSegmentStartIndex;
            Node node = currentSegments.get(i);
            if (i > segments.size() - 1) {
                if (pathRestParam.isEmpty()) {
                    return Pair.of(Collections.emptyList(), (Object)false);
                }
                segment = pathRestParam.get();
            } else {
                segment = segments.get(i);
            }
            if (node.kind() == SyntaxKind.IDENTIFIER_TOKEN && segment.pathSegmentKind() == PathSegment.Kind.NAMED_SEGMENT) {
                String currentPath = ((IdentifierToken)node).text().strip();
                String expectedPath = ((NamedPathSegment)segment).name();
                if (i < numOfProvidedSegments - 1 && currentPath.equals(expectedPath)) continue;
                if (i == numOfProvidedSegments - 1) {
                    if (currentPath.equals(expectedPath)) {
                        if (context.getCursorPositionInTree() != node.textRange().endOffset()) continue;
                        --completableSegmentStartIndex;
                        continue;
                    }
                    if (expectedPath.startsWith(currentPath) && context.getCursorPositionInTree() == node.textRange().endOffset()) {
                        --completableSegmentStartIndex;
                        continue;
                    }
                }
                return Pair.of(Collections.emptyList(), (Object)false);
            }
            if (segment.pathSegmentKind() == PathSegment.Kind.PATH_PARAMETER || segment.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER) {
                TypeSymbol typeSymbol = ((PathParameterSymbol)segment).typeDescriptor();
                Optional semanticModel = context.currentSemanticModel();
                if (semanticModel.isEmpty()) {
                    return Pair.of(Collections.emptyList(), (Object)false);
                }
                if (node.kind() == SyntaxKind.COMPUTED_RESOURCE_ACCESS_SEGMENT) {
                    ExpressionNode exprNode = ((ComputedResourceAccessSegmentNode)node).expression();
                    Optional exprType = ((SemanticModel)semanticModel.get()).typeOf((Node)exprNode);
                    if (exprType.isEmpty() || !ResourcePathCompletionUtil.checkSubtype(typeSymbol, (TypeSymbol)exprType.get(), exprNode.toString())) {
                        return Pair.of(Collections.emptyList(), (Object)false);
                    }
                    if (segment.pathSegmentKind() != PathSegment.Kind.PATH_REST_PARAMETER || ResourcePathCompletionUtil.isInMethodCallContext(accNode, context)) continue;
                    --completableSegmentStartIndex;
                    continue;
                }
                if (node.kind() == SyntaxKind.IDENTIFIER_TOKEN && ResourcePathCompletionUtil.checkSubtype(typeSymbol, ((SemanticModel)semanticModel.get()).types().STRING, "\"" + ((IdentifierToken)node).text() + "\"")) {
                    if (segment.pathSegmentKind() != PathSegment.Kind.PATH_REST_PARAMETER || ResourcePathCompletionUtil.isInMethodCallContext(accNode, context)) continue;
                    --completableSegmentStartIndex;
                    continue;
                }
            }
            return Pair.of(Collections.emptyList(), (Object)false);
        }
        List completableSegments = completableSegmentStartIndex <= segments.size() ? segments.subList(completableSegmentStartIndex, segments.size()) : Collections.emptyList();
        return Pair.of(completableSegments, (Object)true);
    }

    private boolean onSuggestClients(ClientResourceAccessActionNode node, BallerinaCompletionContext context) {
        int cursor = context.getCursorPositionInTree();
        return cursor <= node.rightArrowToken().textRange().startOffset();
    }

    private boolean isInResourceMethodParameterContext(ClientResourceAccessActionNode node, BallerinaCompletionContext context) {
        Optional arguments = node.arguments();
        int cursor = context.getCursorPositionInTree();
        return arguments.isPresent() && ((ParenthesizedArgList)arguments.get()).openParenToken().textRange().startOffset() <= cursor && cursor <= ((ParenthesizedArgList)arguments.get()).closeParenToken().textRange().endOffset();
    }

    private List<LSCompletionItem> getNamedArgExpressionCompletionItems(BallerinaCompletionContext context, ClientResourceAccessActionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional semanticModel = context.currentSemanticModel();
        if (node.arguments().isEmpty() || semanticModel.isEmpty()) {
            return completionItems;
        }
        Optional symbol = ((SemanticModel)semanticModel.get()).symbol((Node)node);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.RESOURCE_METHOD) {
            return completionItems;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
        return this.getNamedArgCompletionItems(context, functionSymbol, (SeparatedNodeList<FunctionArgumentNode>)((ParenthesizedArgList)node.arguments().get()).arguments());
    }

    private boolean isGetMethodWithoutParams(ResourceMethodSymbol resourceMethodSymbol) {
        Optional name = resourceMethodSymbol.getName();
        FunctionTypeSymbol functionTypeSymbol = resourceMethodSymbol.typeDescriptor();
        if (name.isPresent() && !"get".equals(name.get())) {
            return false;
        }
        return (functionTypeSymbol.params().isEmpty() || ((List)functionTypeSymbol.params().get()).isEmpty()) && functionTypeSymbol.restParam().isEmpty();
    }
}

