/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class ComputedResourceAccessSegmentNodeContext
extends AbstractCompletionProvider<ComputedResourceAccessSegmentNode> {
    public ComputedResourceAccessSegmentNodeContext() {
        super(ComputedResourceAccessSegmentNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ComputedResourceAccessSegmentNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)node.expression())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)node.expression();
            Predicate<Symbol> filter = symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, filter);
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ComputedResourceAccessSegmentNode node) {
        Token openBrace = node.openBracketToken();
        Token closeBrace = node.closeBracketToken();
        int cursor = context.getCursorPositionInTree();
        return openBrace.textRange().startOffset() <= cursor && cursor < closeBrace.textRange().endOffset();
    }
}

