/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class DistinctTypeDescriptorNodeContext
extends AbstractCompletionProvider<DistinctTypeDescriptorNode> {
    public DistinctTypeDescriptorNodeContext() {
        super(DistinctTypeDescriptorNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, DistinctTypeDescriptorNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Predicate<Symbol> predicate = CommonUtil.typesFilter().and(symbol -> {
            if (symbol.kind() == SymbolKind.CLASS) {
                return true;
            }
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
                return false;
            }
            TypeSymbol typeSymbol = ((TypeDefinitionSymbol)symbol).typeDescriptor();
            TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
            return rawType.typeKind() == TypeDescKind.OBJECT || rawType.typeKind() == TypeDescKind.ERROR;
        });
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            completionItems.addAll(this.getModuleCompletionItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
            List<Symbol> filteredSymbols = context.visibleSymbols(context.getCursorPosition()).stream().filter(predicate).toList();
            completionItems.addAll(this.getCompletionItemList(filteredSymbols, context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, DistinctTypeDescriptorNode node, List<LSCompletionItem> completionItems) {
        completionItems.forEach(lsCItem -> {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
            lsCItem.getCompletionItem().setSortText(sortText);
        });
    }
}

