/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class EnumMemberNodeContext
extends AbstractCompletionProvider<EnumMemberNode> {
    public EnumMemberNodeContext() {
        super(EnumMemberNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, EnumMemberNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        ArrayList<Symbol> visibleSymbols = new ArrayList<Symbol>();
        Predicate<Symbol> filter = symbol -> symbol.kind() == SymbolKind.CONSTANT && ((ConstantSymbol)symbol).broaderTypeDescriptor().typeKind() == TypeDescKind.STRING;
        if (!this.inEnumMemberValueContext(ctx, node)) {
            return completionItems;
        }
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode nameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            visibleSymbols.addAll(QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)ctx, nameRef, filter));
        } else {
            completionItems.addAll(this.getModuleCompletionItems(ctx));
            List<Symbol> filteredSymbols = ctx.visibleSymbols(ctx.getCursorPosition()).stream().filter(filter).toList();
            visibleSymbols.addAll(filteredSymbols);
        }
        completionItems.addAll(this.getCompletionItemList(visibleSymbols, ctx));
        this.sort(ctx, node, completionItems);
        return completionItems;
    }

    private boolean inEnumMemberValueContext(BallerinaCompletionContext ctx, EnumMemberNode node) {
        Optional equalToken = node.equalToken();
        if (equalToken.isEmpty()) {
            return false;
        }
        return ((Token)equalToken.get()).position() < ctx.getCursorPositionInTree();
    }
}

