/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ErrorMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.MatchStatementContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class ErrorMatchPatternNodeContext
extends MatchStatementContext<ErrorMatchPatternNode> {
    public ErrorMatchPatternNodeContext() {
        super(ErrorMatchPatternNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ErrorMatchPatternNode node) {
        List<Symbol> errorTypes;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            errorTypes = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, this.errorTypeFilter());
        } else {
            List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
            errorTypes = visibleSymbols.stream().filter(this.errorTypeFilter()).toList();
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        completionItems.addAll(this.getCompletionItemList(errorTypes, context));
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private Predicate<Symbol> errorTypeFilter() {
        return symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && this.isValidErrorType((TypeDefinitionSymbol)symbol);
    }

    private boolean isValidErrorType(TypeDefinitionSymbol typeDef) {
        TypeSymbol rawType = CommonUtil.getRawType(typeDef.typeDescriptor());
        if (rawType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)rawType).memberTypeDescriptors().stream().allMatch(typeSymbol -> typeSymbol.kind() == SymbolKind.TYPE_DEFINITION && this.isValidErrorType((TypeDefinitionSymbol)typeSymbol));
        }
        return rawType.typeKind() == TypeDescKind.ERROR;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ErrorMatchPatternNode node) {
        return !node.errorKeyword().isMissing();
    }
}

