/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ExpressionFunctionBodyNodeContext
extends AbstractCompletionProvider<ExpressionFunctionBodyNode> {
    public ExpressionFunctionBodyNodeContext() {
        super(ExpressionFunctionBodyNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, ExpressionFunctionBodyNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> expressionContextEntries = QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef);
            completionItems.addAll(this.getCompletionItemList(expressionContextEntries, ctx));
        } else {
            completionItems.addAll(this.actionKWCompletions(ctx));
            completionItems.addAll(this.expressionCompletions(ctx));
        }
        this.sort(ctx, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ExpressionFunctionBodyNode node) {
        int rightArrowEnd;
        if (node.rightDoubleArrow() == null || node.rightDoubleArrow().isMissing()) {
            return false;
        }
        int cursor = context.getCursorPositionInTree();
        return cursor >= (rightArrowEnd = node.rightDoubleArrow().textRange().endOffset());
    }

    @Override
    public void sort(BallerinaCompletionContext context, ExpressionFunctionBodyNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }
}

