/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class FailStatementNodeContext
extends AbstractCompletionProvider<FailStatementNode> {
    public FailStatementNodeContext() {
        super(FailStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, FailStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode symbolAtCursor = context.getNodeAtCursor();
        if (symbolAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qRef = (QualifiedNameReferenceNode)symbolAtCursor;
            List<Symbol> expressionContextEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qRef);
            completionItems.addAll(this.getCompletionItemList(expressionContextEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, FailStatementNode node, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsCItem : completionItems) {
            if (lsCItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && this.isCompletionItemSubTypeOfError((SymbolCompletionItem)lsCItem)) {
                lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(1));
                continue;
            }
            if (SortingUtil.isModuleCompletionItem(lsCItem) && !SortingUtil.isLangLibModuleCompletionItem(lsCItem)) {
                lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(2));
                continue;
            }
            lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(3));
        }
    }

    private boolean isUnionOfErrors(UnionTypeSymbol unionTypeSymbol) {
        List typeSymbols = unionTypeSymbol.memberTypeDescriptors();
        return typeSymbols.stream().allMatch(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.ERROR);
    }

    private boolean isFunctionReturnsUnionOfErrors(FunctionTypeSymbol functionTypeSymbol) {
        Optional retTypeDec = functionTypeSymbol.returnTypeDescriptor();
        if (retTypeDec.isEmpty()) {
            return false;
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)retTypeDec.get());
        if (rawType.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)rawType;
            return this.isUnionOfErrors(unionTypeSymbol);
        }
        return rawType.typeKind() == TypeDescKind.ERROR;
    }

    private boolean isCompletionItemSubTypeOfError(SymbolCompletionItem symbolCompletionItem) {
        Optional<Symbol> symbol = symbolCompletionItem.getSymbol();
        if (symbol.isEmpty() || symbol.get().kind() == SymbolKind.TYPE_DEFINITION) {
            return false;
        }
        Optional<TypeSymbol> tSymbol = SymbolUtil.getTypeDescriptor(symbol.get());
        if (tSymbol.isEmpty()) {
            return false;
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType(tSymbol.get());
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
            return this.isUnionOfErrors(unionTypeSymbol);
        }
        if (typeSymbol.typeKind() == TypeDescKind.FUNCTION) {
            FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)typeSymbol;
            return this.isFunctionReturnsUnionOfErrors(functionTypeSymbol);
        }
        return typeSymbol.typeKind() == TypeDescKind.ERROR;
    }
}

