/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.IntermediateClauseNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class FromClauseNodeContext
extends IntermediateClauseNodeContext<FromClauseNode> {
    public FromClauseNodeContext() {
        super(FromClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, FromClauseNode node) {
        if (this.onBindingPatternContext(context, node)) {
            return new ArrayList<LSCompletionItem>();
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (this.onTypedBindingPatternContext(context, node)) {
            if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                return this.getCompletionItemList(QNameRefCompletionUtil.getTypesInModule(context, qNameRef), context);
            }
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        } else if (node.inKeyword().isMissing()) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_IN.get()));
        } else if (this.cursorAtTheEndOfClause(context, node)) {
            completionItems.addAll(this.getKeywordCompletions(context, node));
        } else if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, FromClauseNode node) {
        return !node.fromKeyword().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, FromClauseNode node, List<LSCompletionItem> completionItems) {
        List<TypeDescKind> iterables = Arrays.asList(TypeDescKind.STRING, TypeDescKind.ARRAY, TypeDescKind.MAP, TypeDescKind.TABLE, TypeDescKind.STREAM, TypeDescKind.XML);
        Optional expectedTypeSymbol = context.getContextType();
        if (context.getCursorPositionInTree() >= node.inKeyword().textRange().endOffset()) {
            completionItems.forEach(lsCItem -> {
                int rank = 3;
                if (expectedTypeSymbol.isPresent() && SortingUtil.isCompletionItemAssignable(lsCItem, (TypeSymbol)expectedTypeSymbol.get())) {
                    rank = 1;
                } else if (CommonUtil.isCompletionItemOfType(lsCItem, iterables)) {
                    rank = 2;
                }
                String sortText = SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem));
                lsCItem.getCompletionItem().setSortText(sortText);
            });
        } else if (this.onTypedBindingPatternContext(context, node)) {
            completionItems.forEach(lsCItem -> {
                String sortText = expectedTypeSymbol.map(typeSymbol -> SortingUtil.genSortTextByAssignability(context, lsCItem, typeSymbol)).orElseGet(() -> SortingUtil.genSortTextForTypeDescContext(context, lsCItem));
                lsCItem.getCompletionItem().setSortText(sortText);
            });
        }
    }

    private boolean onTypedBindingPatternContext(BallerinaCompletionContext context, FromClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        Token fromKeyword = node.fromKeyword();
        Token inKeyword = node.inKeyword();
        TypedBindingPatternNode typedBindingPattern = node.typedBindingPattern();
        return (cursor > fromKeyword.textRange().endOffset() && inKeyword.isMissing() || cursor > fromKeyword.textRange().endOffset() && cursor < inKeyword.textRange().startOffset()) && (typedBindingPattern.isMissing() || typedBindingPattern.textRange().endOffset() >= cursor);
    }

    private boolean onBindingPatternContext(BallerinaCompletionContext context, FromClauseNode node) {
        TypedBindingPatternNode typedBindingPattern = node.typedBindingPattern();
        if (typedBindingPattern.isMissing()) {
            return false;
        }
        int cursor = context.getCursorPositionInTree();
        Token inKeyword = node.inKeyword();
        TypeDescriptorNode typeDescriptor = typedBindingPattern.typeDescriptor();
        BindingPatternNode bindingPattern = typedBindingPattern.bindingPattern();
        return (cursor > typeDescriptor.textRange().endOffset() && inKeyword.isMissing() || cursor > typeDescriptor.textRange().endOffset() && cursor < inKeyword.textRange().startOffset()) && (bindingPattern.isMissing() || bindingPattern.textRange().endOffset() >= cursor);
    }

    @Override
    protected Optional<Node> getLastNodeOfClause(FromClauseNode node) {
        return Optional.of(node.expression());
    }
}

