/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.GroupByClauseNode;
import io.ballerina.compiler.syntax.tree.GroupingKeyVarDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.IntermediateClauseNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class GroupByClauseNodeContext
extends IntermediateClauseNodeContext<GroupByClauseNode> {
    public GroupByClauseNodeContext() {
        super(GroupByClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, GroupByClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        SeparatedNodeList groupingKey = node.groupingKey();
        if (!groupingKey.isEmpty()) {
            Node groupingKeyNode = groupingKey.get(groupingKey.separatorSize());
            if (groupingKeyNode.kind() == SyntaxKind.GROUPING_KEY_VAR_DECLARATION) {
                return this.getGroupingKeyVarDeclCompletions(context, node, (GroupingKeyVarDeclarationNode)groupingKeyNode);
            }
            if (this.cursorAtTheEndOfClause(groupingKeyNode, context.getCursorPositionInTree())) {
                completionItems.addAll(this.getKeywordCompletions(context, node));
                this.sort(context, node, (List<LSCompletionItem>)completionItems);
                return completionItems;
            }
        }
        completionItems.addAll(this.expressionCompletions(context));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private List<LSCompletionItem> getGroupingKeyVarDeclCompletions(BallerinaCompletionContext context, GroupByClauseNode groupByClauseNode, GroupingKeyVarDeclarationNode groupingKeyNode) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        int cursor = context.getCursorPositionInTree();
        if (this.onBindingPatternContext(cursor, groupingKeyNode)) {
            return completionItems;
        }
        if (this.onTypedBindingPatternContext(cursor, groupingKeyNode)) {
            NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
            if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                return this.getCompletionItemList(QNameRefCompletionUtil.getTypesInModule(context, qNameRef), context);
            }
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, groupByClauseNode, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private boolean onBindingPatternContext(int cursor, GroupingKeyVarDeclarationNode node) {
        return cursor > node.typeDescriptor().textRange().endOffset() && cursor < node.equalsToken().textRange().startOffset();
    }

    private boolean onTypedBindingPatternContext(int cursor, GroupingKeyVarDeclarationNode node) {
        TypeDescriptorNode typeDescriptorNode = node.typeDescriptor();
        return cursor < typeDescriptorNode.textRange().startOffset() || cursor >= typeDescriptorNode.textRange().startOffset() && cursor <= typeDescriptorNode.textRange().endOffset();
    }

    protected boolean cursorAtTheEndOfClause(Node node, int cursor) {
        return cursor > node.textRange().endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, GroupByClauseNode node, List<LSCompletionItem> completionItems) {
        Optional<QueryExpressionNode> queryExprNode = SortingUtil.getTheOutermostQueryExpressionNode((Node)node);
        if (queryExprNode.isEmpty()) {
            return;
        }
        completionItems.forEach(lsCItem -> {
            int rank = 2;
            if (SortingUtil.isSymbolCItemWithinNodeAndCursor(context, lsCItem, (Node)queryExprNode.get())) {
                rank = 1;
            }
            lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
        });
    }
}

