/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class IfElseStatementNodeContext
extends AbstractCompletionProvider<IfElseStatementNode> {
    public IfElseStatementNodeContext() {
        super(IfElseStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, IfElseStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (this.onQualifiedNameIdentifier((CompletionContext)context, (Node)nodeAtCursor)) {
            List<Symbol> expressionContextEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, (QualifiedNameReferenceNode)nodeAtCursor);
            completionItems.addAll(this.getCompletionItemList(expressionContextEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, IfElseStatementNode node) {
        BlockStatementNode ifBody = node.ifBody();
        if (ifBody.openBraceToken().isMissing()) {
            return true;
        }
        int cursor = context.getCursorPositionInTree();
        return cursor <= ifBody.openBraceToken().textRange().startOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, IfElseStatementNode node, List<LSCompletionItem> completionItems) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol booleanTypeSymbol = ((SemanticModel)semanticModel.get()).types().BOOLEAN;
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, booleanTypeSymbol));
        }
    }
}

