/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import com.google.common.collect.Lists;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompletionSearchProvider;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.ImportDeclarationContextUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.wso2.ballerinalang.compiler.util.Names;

public class ImportDeclarationNodeContext
extends AbstractCompletionProvider<ImportDeclarationNode> {
    private static final String LANGLIB_MODULE_PREFIX = Names.BALLERINA_ORG.getValue() + Names.ORG_NAME_SEPARATOR.getValue() + Names.LANG.getValue() + Names.DOT.getValue();
    private static final String BALLERINA_MODULE_PREFIX = Names.BALLERINA_ORG.getValue() + Names.ORG_NAME_SEPARATOR.getValue();

    public ImportDeclarationNodeContext() {
        super(ImportDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, ImportDeclarationNode node) {
        ContextScope contextScope;
        List<IdentifierToken> moduleName = node.moduleName().stream().filter(token -> !token.isMissing()).toList();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onPrefixContext(ctx, node)) {
            return Collections.emptyList();
        }
        if (this.onSuggestCurrentProjectModules(ctx, node, moduleName)) {
            completionItems.addAll(this.getCurrentProjectModules(ctx, moduleName));
            contextScope = ContextScope.OTHER;
        } else if (this.onSuggestAsKeyword(ctx, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.KW_AS.get()));
            contextScope = ContextScope.AS_KW;
        } else if (node.orgName().isPresent()) {
            completionItems.addAll(this.moduleNameContextCompletions(ctx, node));
            contextScope = ContextScope.MODULE_NAME;
        } else {
            completionItems.addAll(this.orgNameContextCompletions(ctx));
            contextScope = ContextScope.ORG_NAME;
        }
        this.sort(ctx, node, (List<LSCompletionItem>)completionItems, new Object[]{contextScope});
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ImportDeclarationNode node, List<LSCompletionItem> cItems, Object ... metaData) {
        if (metaData.length == 0 || !(metaData[0] instanceof ContextScope)) {
            super.sort(context, node, cItems, metaData);
            return;
        }
        if (metaData[0] == ContextScope.MODULE_NAME) {
            String modulePart = null;
            if (node.moduleName().size() > 1) {
                StringBuilder modName = new StringBuilder();
                for (int i = 0; i < node.moduleName().size() - 1; ++i) {
                    modName.append(((IdentifierToken)node.moduleName().get(i)).text());
                    modName.append(".");
                }
                modulePart = modName.toString();
            }
            for (LSCompletionItem completion : cItems) {
                CompletionItem cItem = completion.getCompletionItem();
                String label = cItem.getLabel();
                cItem.setSortText(SortingUtil.genSortText(this.rankModuleName(label, modulePart)));
            }
            return;
        }
        if (metaData[0] == ContextScope.ORG_NAME) {
            for (LSCompletionItem completion : cItems) {
                CompletionItem cItem = completion.getCompletionItem();
                String label = cItem.getLabel();
                cItem.setSortText(SortingUtil.genSortText(this.rankOrgName(label)));
            }
            return;
        }
        super.sort(context, node, cItems, metaData);
    }

    private int rankModuleName(String label, String modulePart) {
        if (modulePart != null && label.startsWith(modulePart)) {
            return 1;
        }
        if (label.startsWith(LANGLIB_MODULE_PREFIX)) {
            return 2;
        }
        if (label.startsWith(BALLERINA_MODULE_PREFIX)) {
            return 3;
        }
        return 4;
    }

    private int rankOrgName(String label) {
        if (!label.contains(Names.ORG_NAME_SEPARATOR.getValue()) && !label.equals(Names.BALLERINA_ORG.getValue())) {
            return 1;
        }
        if (!label.contains(Names.ORG_NAME_SEPARATOR.getValue())) {
            return 2;
        }
        if (label.startsWith(Names.BALLERINA_ORG.getValue() + Names.ORG_NAME_SEPARATOR.getValue())) {
            return 3;
        }
        if (label.startsWith(Names.BALLERINA_ORG.getValue() + Names.ORG_NAME_SEPARATOR.getValue() + Names.LANG.getValue() + Names.DOT.getValue())) {
            return 4;
        }
        return 5;
    }

    private ArrayList<LSCompletionItem> orgNameContextCompletions(BallerinaCompletionContext ctx) {
        HashSet orgNames = new HashSet();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<LSPackageLoader.ModuleInfo> moduleList = LSPackageLoader.getInstance(ctx.languageServercontext()).getAllVisiblePackages((DocumentServiceContext)ctx);
        moduleList.forEach(pkg -> {
            Object insertText;
            String orgName = pkg.packageOrg();
            String pkgName = pkg.packageName();
            if (orgName.equals(Names.BALLERINA_INTERNAL_ORG.getValue()) || ModuleUtil.matchingImportedModule((CompletionContext)ctx, pkg).isPresent()) {
                return;
            }
            List<String> pkgNameComps = Arrays.stream(pkgName.split("\\.")).map(ModuleUtil::escapeModuleName).map(CommonUtil::escapeReservedKeyword).toList();
            String label = pkg.packageOrg().isEmpty() ? String.join((CharSequence)".", pkgNameComps) : CommonUtil.getPackageLabel(pkg);
            Object object = insertText = orgName.isEmpty() ? "" : orgName + Names.ORG_NAME_SEPARATOR.getValue();
            insertText = orgName.equals(Names.BALLERINA_ORG.value) && pkgName.startsWith("lang" + Names.DOT.getValue()) ? (String)insertText + ImportDeclarationContextUtil.getLangLibModuleNameInsertText(pkgName) : (String)insertText + (orgName.isEmpty() ? label : pkgName);
            LSCompletionItem fullPkgImport = ImportDeclarationContextUtil.getImportCompletion(ctx, label, (String)insertText);
            completionItems.add(fullPkgImport);
            if (!orgName.isEmpty() && !orgNames.contains(orgName)) {
                LSCompletionItem orgNameImport = ImportDeclarationContextUtil.getImportCompletion(ctx, orgName, orgName + Names.ORG_NAME_SEPARATOR.getValue());
                completionItems.add(orgNameImport);
                orgNames.add(orgName);
            }
        });
        return completionItems;
    }

    private List<LSCompletionItem> getCurrentProjectModules(BallerinaCompletionContext context, List<IdentifierToken> moduleName) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        String pkgName = ((Module)context.workspace().module(context.filePath()).get()).packageInstance().packageName().value();
        List<String> modNameString = moduleName.stream().map(token -> token.text().replace("'", "")).toList();
        Optional currentProject = context.workspace().project(context.filePath());
        if (currentProject.isEmpty() || ((Project)currentProject.get()).kind() == ProjectKind.SINGLE_FILE_PROJECT || !modNameString.get(0).equals(pkgName)) {
            return completionItems;
        }
        Optional currentModule = context.currentModule();
        ((Project)currentProject.get()).currentPackage().modules().forEach(module -> {
            String qualifiedModuleName = module.moduleName().packageName().toString() + String.valueOf(Names.DOT) + module.moduleName().moduleNamePart();
            if (module.isDefaultModule() || currentModule.isPresent() && module.moduleId().equals((Object)((Module)currentModule.get()).moduleId()) || ModuleUtil.matchingImportedModule((DocumentServiceContext)context, "", qualifiedModuleName).isPresent()) {
                return;
            }
            ArrayList moduleNameParts = Lists.newArrayList((Object[])module.moduleName().moduleNamePart().split("\\."));
            moduleName.forEach(token -> moduleNameParts.remove(token.text()));
            String label = module.moduleName().moduleNamePart();
            String insertText = moduleNameParts.stream().map(CommonUtil::escapeReservedKeyword).collect(Collectors.joining("."));
            completionItems.add(ImportDeclarationContextUtil.getImportCompletion(context, label, insertText));
        });
        return completionItems;
    }

    private ArrayList<LSCompletionItem> moduleNameContextCompletions(BallerinaCompletionContext context, ImportDeclarationNode node) {
        List<LSPackageLoader.ModuleInfo> moduleList;
        String orgName = ((ImportOrgNameNode)node.orgName().get()).orgName().text();
        ArrayList<TextEdit> additionalEdits = new ArrayList<TextEdit>();
        if (node.moduleName().size() > 1) {
            IdentifierToken lastModeNamePart = (IdentifierToken)node.moduleName().get(node.moduleName().size() - 1);
            LinePosition startPos = ((ImportOrgNameNode)node.orgName().get()).lineRange().endLine();
            LinePosition endPos = lastModeNamePart.lineRange().endLine();
            if (!lastModeNamePart.isMissing()) {
                endPos = lastModeNamePart.lineRange().startLine();
            }
            Range editRange = new Range(PositionUtil.toPosition(startPos), PositionUtil.toPosition(endPos));
            TextEdit removeModNameEdit = new TextEdit(editRange, "");
            additionalEdits.add(removeModNameEdit);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList addedPkgNames = new ArrayList();
        LanguageServerContext serverContext = context.languageServercontext();
        if (orgName.equals("ballerinax")) {
            ArrayList<String> packageList = new ArrayList<String>();
            String prefix = node.moduleName().stream().filter(identifierToken -> !identifierToken.isMissing()).map(Token::text).collect(Collectors.joining("."));
            moduleList = LSPackageLoader.getInstance(serverContext).getCentralPackages();
            moduleList.forEach(ballerinaPackage -> packageList.add(ballerinaPackage.packageName()));
            List<String> filteredPackageNames = ImportDeclarationNodeContext.getFilteredPackages(packageList, prefix, context);
            for (String filteredPackage : filteredPackageNames) {
                LSCompletionItem completionItem = ImportDeclarationContextUtil.getImportCompletion(context, filteredPackage, filteredPackage);
                completionItem.getCompletionItem().setAdditionalTextEdits(additionalEdits);
                completionItems.add(completionItem);
            }
            return completionItems;
        }
        moduleList = LSPackageLoader.getInstance(serverContext).getAllVisiblePackages((DocumentServiceContext)context);
        moduleList.forEach(ballerinaPackage -> {
            String packageName = ballerinaPackage.packageName();
            if (orgName.equals(ballerinaPackage.packageOrg()) && !addedPkgNames.contains(packageName) && ModuleUtil.matchingImportedModule((CompletionContext)context, ballerinaPackage).isEmpty()) {
                String insertText = orgName.equals(Names.BALLERINA_ORG.value) && packageName.startsWith(Names.LANG.getValue() + Names.DOT.getValue()) ? ImportDeclarationContextUtil.getLangLibModuleNameInsertText(packageName) : packageName;
                addedPkgNames.add(packageName);
                LSCompletionItem completionItem = ImportDeclarationContextUtil.getImportCompletion(context, packageName, insertText);
                completionItem.getCompletionItem().setAdditionalTextEdits(additionalEdits);
                completionItems.add(completionItem);
            }
        });
        return completionItems;
    }

    private static List<String> getFilteredPackages(List<String> packageList, String prefix, BallerinaCompletionContext context) {
        CompletionSearchProvider completionSearchProvider = CompletionSearchProvider.getInstance(context.languageServercontext());
        completionSearchProvider.indexNames(packageList);
        return completionSearchProvider.getSuggestions(prefix);
    }

    private boolean onSuggestAsKeyword(BallerinaCompletionContext context, ImportDeclarationNode node) {
        SeparatedNodeList moduleName = node.moduleName();
        if (moduleName.isEmpty() || ((IdentifierToken)moduleName.get(moduleName.size() - 1)).isMissing()) {
            return false;
        }
        int moduleNameEnd = ((IdentifierToken)moduleName.get(moduleName.size() - 1)).textRange().endOffset();
        int cursor = context.getCursorPositionInTree();
        return (node.prefix().isEmpty() || ((ImportPrefixNode)node.prefix().get()).asKeyword().isMissing()) && cursor > moduleNameEnd;
    }

    private boolean onPrefixContext(BallerinaCompletionContext context, ImportDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Optional prefix = node.prefix();
        return prefix.isPresent() && !((ImportPrefixNode)prefix.get()).asKeyword().isMissing() && cursor > ((ImportPrefixNode)prefix.get()).asKeyword().textRange().endOffset();
    }

    private boolean onSuggestCurrentProjectModules(BallerinaCompletionContext context, ImportDeclarationNode node, List<IdentifierToken> moduleNameComponents) {
        Optional module = context.currentModule();
        int cursor = context.getCursorPositionInTree();
        return !moduleNameComponents.isEmpty() && module.isPresent() && (moduleNameComponents.size() >= 2 || node.moduleName().separatorSize() != 0) && node.orgName().isEmpty() && moduleNameComponents.get(moduleNameComponents.size() - 1).textRange().endOffset() <= cursor;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ImportDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token semicolon = node.semicolon();
        if (semicolon.isMissing()) {
            return true;
        }
        return cursor < semicolon.textRange().endOffset();
    }

    private static enum ContextScope {
        AS_KW,
        MODULE_NAME,
        ORG_NAME,
        OTHER;

    }
}

