/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class IncludedRecordParameterNodeContext
extends AbstractCompletionProvider<IncludedRecordParameterNode> {
    public IncludedRecordParameterNodeContext() {
        super(IncludedRecordParameterNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, IncludedRecordParameterNode node) {
        List<Symbol> recordTypes;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == TypeDescKind.RECORD;
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode nameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            recordTypes = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)ctx, nameRef, predicate);
        } else {
            List visibleSymbols = ctx.visibleSymbols(ctx.getCursorPosition());
            recordTypes = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == TypeDescKind.RECORD).toList();
            completionItems.addAll(Arrays.asList(new SnippetCompletionItem(ctx, Snippet.KW_RECORD.get()), new SnippetCompletionItem(ctx, Snippet.DEF_RECORD_TYPE_DESC.get()), new SnippetCompletionItem(ctx, Snippet.DEF_CLOSED_RECORD_TYPE_DESC.get())));
            completionItems.addAll(this.getModuleCompletionItems(ctx));
        }
        completionItems.addAll(this.getCompletionItemList(recordTypes, ctx));
        this.sort(ctx, node, completionItems);
        return completionItems;
    }
}

