/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompleteExpressionValidator;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.QueryExpressionUtil;

public abstract class IntermediateClauseNodeContext<T extends IntermediateClauseNode>
extends AbstractCompletionProvider<T> {
    public IntermediateClauseNodeContext(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    protected List<LSCompletionItem> getKeywordCompletions(BallerinaCompletionContext context, T node) {
        return QueryExpressionUtil.getCommonKeywordCompletions(context);
    }

    protected boolean cursorAtTheEndOfClause(BallerinaCompletionContext context, T node) {
        Optional<Node> lastNode = this.getLastNodeOfClause(node);
        if (lastNode.isEmpty() || lastNode.get().isMissing()) {
            return false;
        }
        CompleteExpressionValidator validator = new CompleteExpressionValidator();
        boolean completed = (Boolean)lastNode.get().apply((NodeTransformer)validator);
        int cursor = context.getCursorPositionInTree();
        return lastNode.get().textRange().endOffset() < cursor && completed;
    }

    protected Optional<Node> getLastNodeOfClause(T node) {
        return Optional.empty();
    }
}

