/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.TypeResolverUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.NamedArgCompletionItem;
import org.ballerinalang.langserver.completions.builder.NamedArgCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class InvocationNodeContextProvider<T extends Node>
extends AbstractCompletionProvider<T> {
    public InvocationNodeContextProvider(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, T node) {
        return Collections.emptyList();
    }

    @Override
    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems) {
        if (node.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION && !TypeResolverUtil.isInNewExpressionParameterContext((ExplicitNewExpressionNode)node, context.getCursorPositionInTree()).booleanValue() || node.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION && !TypeResolverUtil.isInNewExpressionParameterContext((ImplicitNewExpressionNode)node, context.getCursorPositionInTree()).booleanValue()) {
            super.sort(context, node, completionItems);
            return;
        }
        Optional<TypeSymbol> parameterSymbol = InvocationNodeContextProvider.getParameterTypeSymbol(context);
        for (LSCompletionItem completionItem : completionItems) {
            if (completionItem.getType() == LSCompletionItem.CompletionItemType.NAMED_ARG) {
                InvocationNodeContextProvider.sortNamedArgCompletionItem(context, completionItem);
                continue;
            }
            if (parameterSymbol.isEmpty()) {
                InvocationNodeContextProvider.sortParameterlessCompletionItem(context, completionItem);
                continue;
            }
            InvocationNodeContextProvider.sortDefaultCompletionItem(context, parameterSymbol.get(), completionItem);
        }
    }

    protected static Optional<TypeSymbol> getParameterTypeSymbol(BallerinaCompletionContext context) {
        Optional parameterSymbol = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            parameterSymbol = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), LinePosition.from((int)context.getCursorPosition().getLine(), (int)context.getCursorPosition().getCharacter()));
        }
        return parameterSymbol;
    }

    protected static void sortNamedArgCompletionItem(BallerinaCompletionContext context, LSCompletionItem completionItem) {
        RecordFieldSymbol right;
        NamedArgCompletionItem argCompletionItem = (NamedArgCompletionItem)completionItem;
        Either<ParameterSymbol, RecordFieldSymbol> symbol = argCompletionItem.getParameterSymbol();
        String sortText = symbol.isRight() ? ((right = (RecordFieldSymbol)symbol.getRight()).isOptional() ? SortingUtil.genSortText(1) + SortingUtil.genSortText(3) : (right.hasDefaultValue() ? SortingUtil.genSortText(1) + SortingUtil.genSortText(2) : SortingUtil.genSortText(1) + SortingUtil.genSortText(1))) : SortingUtil.genSortText(1) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
        completionItem.getCompletionItem().setSortText(sortText);
    }

    private static void sortParameterlessCompletionItem(BallerinaCompletionContext context, LSCompletionItem completionItem) {
        completionItem.getCompletionItem().setSortText(SortingUtil.genSortText(SortingUtil.toRank(context, completionItem)));
    }

    protected static void sortDefaultCompletionItem(BallerinaCompletionContext context, TypeSymbol parameterSymbol, LSCompletionItem completionItem) {
        completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, parameterSymbol));
    }

    protected List<LSCompletionItem> getNamedArgCompletionItems(BallerinaCompletionContext context, FunctionSymbol functionSymbol, SeparatedNodeList<FunctionArgumentNode> argumentNodeList) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (!this.isValidNamedArgContext(context, argumentNodeList)) {
            return completionItems;
        }
        FunctionTypeSymbol functionTypeSymbol = functionSymbol.typeDescriptor();
        Optional params = functionTypeSymbol.params();
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> existingNamedArgs = NameUtil.getDefinedArgumentNames(context, (List)params.get(), argumentNodeList);
        for (ParameterSymbol parameterSymbol : (List)params.get()) {
            TypeSymbol typeSymbol;
            if (parameterSymbol.paramKind() == ParameterKind.REQUIRED || parameterSymbol.paramKind() == ParameterKind.DEFAULTABLE) {
                Optional paramName = parameterSymbol.getName();
                if (paramName.isEmpty() || ((String)paramName.get()).isEmpty() || existingNamedArgs.contains(paramName.get())) continue;
                CompletionItem completionItem = NamedArgCompletionItemBuilder.build((String)paramName.get(), parameterSymbol.typeDescriptor());
                completionItems.add((LSCompletionItem)new NamedArgCompletionItem(context, completionItem, (Either<ParameterSymbol, RecordFieldSymbol>)Either.forLeft((Object)parameterSymbol)));
                continue;
            }
            if (parameterSymbol.paramKind() != ParameterKind.INCLUDED_RECORD || (typeSymbol = CommonUtil.getRawType(parameterSymbol.typeDescriptor())).typeKind() != TypeDescKind.RECORD) continue;
            RecordTypeSymbol includedRecordType = (RecordTypeSymbol)typeSymbol;
            Map fieldSymbolMap = includedRecordType.fieldDescriptors();
            fieldSymbolMap.forEach((key, value) -> {
                Optional fieldName = value.getName();
                if (fieldName.isEmpty() || ((String)fieldName.get()).isEmpty() || existingNamedArgs.contains(fieldName.get())) {
                    return;
                }
                TypeSymbol fieldType = value.typeDescriptor();
                CompletionItem completionItem = NamedArgCompletionItemBuilder.build((String)fieldName.get(), fieldType);
                completionItems.add((LSCompletionItem)new NamedArgCompletionItem(context, completionItem, (Either<ParameterSymbol, RecordFieldSymbol>)Either.forRight((Object)value)));
            });
        }
        return completionItems;
    }

    private boolean isValidNamedArgContext(BallerinaCompletionContext context, SeparatedNodeList<FunctionArgumentNode> argumentNodeList) {
        int cursorPosition = context.getCursorPositionInTree();
        for (Node child : argumentNodeList) {
            TextRange textRange = child.textRange();
            int startOffset = textRange.startOffset();
            if ((startOffset <= cursorPosition || child.kind() != SyntaxKind.POSITIONAL_ARG) && child.kind() != SyntaxKind.REST_ARG) continue;
            return false;
        }
        return true;
    }

    protected boolean isNotInNamedArgOnlyContext(BallerinaCompletionContext context, List<? extends Node> arguments) {
        int cursorPosition = context.getCursorPositionInTree();
        for (Node node : arguments) {
            TextRange textRange = node.textRange();
            int endOffset = textRange.endOffset();
            if (endOffset > cursorPosition || node.kind() != SyntaxKind.NAMED_ARG) continue;
            return false;
        }
        return true;
    }
}

