/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.JoinClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompleteExpressionValidator;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.IntermediateClauseNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class JoinClauseNodeContext
extends IntermediateClauseNodeContext<JoinClauseNode> {
    public JoinClauseNodeContext() {
        super(JoinClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, JoinClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (this.onSuggestBindingPattern(context, node)) {
            if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                return this.getCompletionItemList(QNameRefCompletionUtil.getTypesInModule(context, qNameRef), context);
            }
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        } else if (this.onSuggestInKeyword(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_IN.get()));
        } else if (this.onSuggestOnKeyword(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ON.get()));
        } else if (this.cursorAtTheEndOfClause(context, node)) {
            completionItems.addAll(this.getKeywordCompletions(context, node));
        } else if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else if (!this.isMissingVarName(node.typedBindingPattern()) && context.getCursorPositionInTree() > node.typedBindingPattern().bindingPattern().textRange().endOffset()) {
            completionItems.addAll(this.expressionCompletions(context));
        } else {
            return Collections.emptyList();
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, JoinClauseNode node) {
        return !node.joinKeyword().isMissing();
    }

    @Override
    protected Optional<Node> getLastNodeOfClause(JoinClauseNode node) {
        return Optional.of(node.joinOnCondition());
    }

    private boolean onSuggestBindingPattern(BallerinaCompletionContext context, JoinClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        TypedBindingPatternNode typedBindingPattern = node.typedBindingPattern();
        CompleteExpressionValidator validator = new CompleteExpressionValidator();
        return (Boolean)typedBindingPattern.typeDescriptor().apply((NodeTransformer)validator) == false || cursor <= typedBindingPattern.typeDescriptor().textRange().endOffset() && cursor > node.joinKeyword().textRange().endOffset() && cursor < typedBindingPattern.bindingPattern().textRange().startOffset();
    }

    private boolean onSuggestInKeyword(BallerinaCompletionContext context, JoinClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        TypedBindingPatternNode typedBindingPattern = node.typedBindingPattern();
        if (!node.inKeyword().isMissing()) {
            return false;
        }
        if (cursor > typedBindingPattern.textRange().endOffset() && cursor <= node.expression().textRange().startOffset() && !this.isMissingVarName(typedBindingPattern)) {
            return true;
        }
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode nameReferenceNode = (SimpleNameReferenceNode)nodeAtCursor;
            return node.expression().textRange().startOffset() + 1 == cursor && nameReferenceNode.textRange().startOffset() + 1 == cursor;
        }
        return false;
    }

    private boolean onSuggestOnKeyword(BallerinaCompletionContext context, JoinClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        if (node.typedBindingPattern().isMissing() || node.typedBindingPattern().isMissing() || node.inKeyword().isMissing() || node.expression().isMissing() || !node.joinOnCondition().onKeyword().isMissing()) {
            return false;
        }
        if (node.expression().textRange().endOffset() < cursor && cursor <= node.joinOnCondition().textRange().startOffset()) {
            return true;
        }
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && !nodeAtCursor.equals(node.expression())) {
            SimpleNameReferenceNode nameReferenceNode = (SimpleNameReferenceNode)nodeAtCursor;
            return node.expression().textRange().endOffset() <= cursor && nameReferenceNode.textRange().endOffset() == cursor;
        }
        return false;
    }

    private boolean isMissingVarName(TypedBindingPatternNode node) {
        BindingPatternNode bindingPattern = node.bindingPattern();
        return bindingPattern.kind() == SyntaxKind.CAPTURE_BINDING_PATTERN && ((CaptureBindingPatternNode)bindingPattern).variableName().isMissing();
    }
}

