/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.LetClauseNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.IntermediateClauseNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class LetClauseNodeContext
extends IntermediateClauseNodeContext<LetClauseNode> {
    public LetClauseNodeContext() {
        super(LetClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, LetClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (this.cursorAtTheEndOfClause(context, node)) {
            completionItems.addAll(this.getKeywordCompletions(context, node));
        } else if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(typesInModule, context));
        } else {
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    protected boolean cursorAtTheEndOfClause(BallerinaCompletionContext context, LetClauseNode node) {
        SeparatedNodeList letVarDecls = node.letVarDeclarations();
        if (letVarDecls.isEmpty()) {
            return false;
        }
        int cursor = context.getCursorPositionInTree();
        int immediateLetVarDecl = 0;
        for (int i = letVarDecls.size() - 1; i >= 0; --i) {
            LetVariableDeclarationNode letVarDecl = (LetVariableDeclarationNode)letVarDecls.get(i);
            ExpressionNode expr = letVarDecl.expression();
            if (!this.isCompleteLetVarDeclaration(letVarDecl) || cursor < expr.textRange().endOffset()) continue;
            immediateLetVarDecl = i;
            break;
        }
        if (letVarDecls.separatorSize() > immediateLetVarDecl && !letVarDecls.getSeparator(immediateLetVarDecl).isMissing() && cursor > letVarDecls.getSeparator(immediateLetVarDecl).textRange().startOffset()) {
            return false;
        }
        LetVariableDeclarationNode letVarDecl = (LetVariableDeclarationNode)letVarDecls.get(immediateLetVarDecl);
        return this.isCompleteLetVarDeclaration(letVarDecl) && cursor >= letVarDecl.textRange().endOffset() - letVarDecl.trailingMinutiae().size();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, LetClauseNode node) {
        return !node.letKeyword().isMissing();
    }

    private boolean isCompleteLetVarDeclaration(LetVariableDeclarationNode node) {
        return !node.typedBindingPattern().isMissing() && !node.equalsToken().isMissing() && !node.expression().isMissing();
    }
}

