/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompleteExpressionValidator;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public class LetExpressionNodeContext
extends AbstractCompletionProvider<LetExpressionNode> {
    public LetExpressionNodeContext() {
        super(LetExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, LetExpressionNode node) throws LSCompletionException {
        SeparatedNodeList letVarDeclarations = node.letVarDeclarations();
        if (!letVarDeclarations.isEmpty() && (letVarDeclarations.isEmpty() || ((LetVariableDeclarationNode)letVarDeclarations.get(letVarDeclarations.size() - 1)).textRange().length() != 0)) {
            if (this.onSuggestInKeyword(context, node)) {
                return Collections.singletonList(new SnippetCompletionItem(context, Snippet.KW_IN.get()));
            }
            return CompletionUtil.route(context, (Node)node.parent());
        }
        List<LSCompletionItem> completionItems = this.getTypeDescContextItems(context);
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, LetExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        SeparatedNodeList letVarDeclarations = node.letVarDeclarations();
        if (letVarDeclarations.isEmpty() || !letVarDeclarations.isEmpty() && ((LetVariableDeclarationNode)letVarDeclarations.get(letVarDeclarations.size() - 1)).textRange().length() == 0) {
            return true;
        }
        CompleteExpressionValidator validator = new CompleteExpressionValidator();
        return !letVarDeclarations.isEmpty() && node.inKeyword().isMissing() && ((LetVariableDeclarationNode)letVarDeclarations.get(letVarDeclarations.size() - 1)).expression().textRange().endOffset() <= cursor;
    }

    @Override
    public void sort(BallerinaCompletionContext context, LetExpressionNode node, List<LSCompletionItem> lsCItems) {
        for (LSCompletionItem lsCItem : lsCItems) {
            CompletionItem completionItem = lsCItem.getCompletionItem();
            completionItem.setSortText(SortingUtil.genSortTextForTypeDescContext(context, lsCItem));
        }
    }

    private boolean onSuggestInKeyword(BallerinaCompletionContext context, LetExpressionNode node) {
        SeparatedNodeList letVarDecls = node.letVarDeclarations();
        int cursor = context.getCursorPositionInTree();
        CompleteExpressionValidator validator = new CompleteExpressionValidator();
        if (letVarDecls.isEmpty()) {
            return false;
        }
        ExpressionNode expression = ((LetVariableDeclarationNode)letVarDecls.get(letVarDecls.size() - 1)).expression();
        boolean completed = (Boolean)expression.apply((NodeTransformer)validator);
        Object evalNode = expression.kind() == SyntaxKind.BINARY_EXPRESSION && completed && ((BinaryExpressionNode)expression).operator().isMissing() ? ((BinaryExpressionNode)expression).lhsExpr() : expression;
        return node.inKeyword().isMissing() && completed && evalNode.textRange().endOffset() < cursor;
    }
}

