/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ComputedNameFieldNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.RecordField;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.SpreadCompletionItem;
import org.ballerinalang.langserver.completions.builder.SpreadCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public abstract class MappingContextProvider<T extends Node>
extends AbstractCompletionProvider<T> {
    public MappingContextProvider(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    protected abstract List<String> getFields(T var1);

    protected Predicate<Symbol> getVariableFilter() {
        return CommonUtil.getVariableFilterPredicate().or(symbol -> symbol.kind() == SymbolKind.CONSTANT);
    }

    protected boolean withinValueExpression(BallerinaCompletionContext context, Node evalNodeAtCursor) {
        Token colon;
        if (evalNodeAtCursor.kind() == SyntaxKind.SPECIFIC_FIELD) {
            Optional optionalColon = ((SpecificFieldNode)evalNodeAtCursor).colon();
            if (optionalColon.isEmpty()) {
                return false;
            }
            colon = (Token)optionalColon.get();
        } else if (evalNodeAtCursor.kind() == SyntaxKind.COMPUTED_NAME_FIELD) {
            colon = ((ComputedNameFieldNode)evalNodeAtCursor).colonToken();
        } else {
            return false;
        }
        int cursorPosInTree = context.getCursorPositionInTree();
        int colonStart = colon.textRange().startOffset();
        return cursorPosInTree > colonStart;
    }

    protected List<RawTypeSymbolWrapper<RecordTypeSymbol>> getRecordTypeDescs(BallerinaCompletionContext context, Node node) {
        Optional resolvedType = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.location().lineRange().endLine();
            resolvedType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (resolvedType.isEmpty()) {
            return Collections.emptyList();
        }
        return RecordUtil.getRecordTypeSymbols((TypeSymbol)resolvedType.get());
    }

    protected List<LSCompletionItem> getVariableCompletionsForFields(BallerinaCompletionContext ctx, Map<String, RecordFieldSymbol> recFields) {
        List<Symbol> visibleSymbols = ctx.visibleSymbols(ctx.getCursorPosition()).stream().filter(this.getVariableFilter().and(symbol -> {
            Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
            Optional symbolName = symbol.getName();
            return symbolName.isPresent() && typeDescriptor.isPresent() && recFields.containsKey(symbolName.get()) && ((RecordFieldSymbol)recFields.get(symbolName.get())).typeDescriptor().typeKind() == typeDescriptor.get().typeKind();
        })).toList();
        return this.getCompletionItemList(visibleSymbols, ctx);
    }

    protected List<LSCompletionItem> getExpressionsCompletionsForQNameRef(BallerinaCompletionContext context, QualifiedNameReferenceNode qNameRef) {
        Predicate<Symbol> filter = symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION;
        List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, filter);
        return this.getCompletionItemList(moduleContent, context);
    }

    protected boolean hasReadonlyKW(Node evalNodeAtCursor) {
        return evalNodeAtCursor.kind() == SyntaxKind.SPECIFIC_FIELD && ((SpecificFieldNode)evalNodeAtCursor).readonlyKeyword().isPresent();
    }

    protected List<LSCompletionItem> getFieldCompletionItems(BallerinaCompletionContext context, T node, Node evalNode) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (!this.hasReadonlyKW(evalNode)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_READONLY.get()));
        }
        List<RawTypeSymbolWrapper<RecordTypeSymbol>> recordTypeDescriptors = this.getRecordTypeDescs(context, (Node)node);
        List<String> existingFields = this.getFields(node);
        ArrayList<RecordFieldSymbol> validFields = new ArrayList<RecordFieldSymbol>();
        HashMap<RecordField.RecordFieldIdentifier, List<RecordField>> recordFieldMap = new HashMap<RecordField.RecordFieldIdentifier, List<RecordField>>();
        for (RawTypeSymbolWrapper<RecordTypeSymbol> wrapper : recordTypeDescriptors) {
            Map<String, RecordFieldSymbol> fields = RecordUtil.getRecordFields(wrapper, existingFields);
            fields.forEach((key, value) -> {
                RecordField recordField = new RecordField((String)key, (RecordFieldSymbol)value, wrapper);
                RecordField.RecordFieldIdentifier identifier = new RecordField.RecordFieldIdentifier((String)key, recordField.getFieldSymbol().typeDescriptor());
                if (!recordFieldMap.containsKey(identifier)) {
                    recordFieldMap.put(identifier, new ArrayList<RecordField>(List.of(recordField)));
                } else {
                    ((List)recordFieldMap.get(identifier)).add(recordField);
                }
            });
            validFields.addAll(fields.values());
            if (!fields.values().isEmpty()) {
                Optional<LSCompletionItem> fillAllStructFieldsItem = RecordUtil.getFillAllRecordFieldCompletionItems(context, fields, wrapper);
                fillAllStructFieldsItem.ifPresent(completionItems::add);
            }
            completionItems.addAll(this.getSpreadFieldCompletionItemsForRecordFields(context, validFields));
            completionItems.addAll(this.getVariableCompletionsForFields(context, fields));
        }
        completionItems.addAll(RecordUtil.getRecordFieldCompletionItems(context, recordFieldMap));
        if (recordTypeDescriptors.isEmpty() || validFields.isEmpty()) {
            List<Symbol> variables = context.visibleSymbols(context.getCursorPosition()).stream().filter(this.getVariableFilter()).filter(varSymbol -> varSymbol.getName().isPresent()).filter(varSymbol -> !existingFields.contains(varSymbol.getName().get())).toList();
            completionItems.addAll(this.getCompletionItemList(variables, context));
            if (existingFields.isEmpty() && evalNode.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
                completionItems.addAll(this.getSpreadFieldCompletionItemsForMap((MappingConstructorExpressionNode)evalNode, context));
            }
        }
        return completionItems;
    }

    private List<LSCompletionItem> getSpreadFieldCompletionItemsForMap(MappingConstructorExpressionNode node, BallerinaCompletionContext context) {
        if (context.currentSemanticModel().isEmpty() || context.currentDocument().isEmpty()) {
            return Collections.emptyList();
        }
        LinePosition linePosition = node.location().lineRange().endLine();
        Optional resolvedType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        if (resolvedType.isEmpty()) {
            return Collections.emptyList();
        }
        Predicate<Symbol> symbolFilter = this.getVariableFilter();
        List<Symbol> visibleSymbols = context.visibleSymbols(context.getCursorPosition()).stream().filter(symbolFilter.and(symbol -> {
            Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol).map(CommonUtil::getRawType);
            if (typeDescriptor.isEmpty() || typeDescriptor.get().typeKind() != TypeDescKind.MAP) {
                return false;
            }
            MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)typeDescriptor.get();
            if (((TypeSymbol)resolvedType.get()).typeKind() != TypeDescKind.MAP && mapTypeSymbol.typeParam().subtypeOf((TypeSymbol)resolvedType.get())) {
                return true;
            }
            return ((TypeSymbol)resolvedType.get()).typeKind() == TypeDescKind.MAP && mapTypeSymbol.subtypeOf((TypeSymbol)resolvedType.get());
        })).toList();
        return this.getSpreadFieldCompletionItemList(visibleSymbols, context);
    }

    private List<LSCompletionItem> getSpreadFieldCompletionItemsForRecordFields(BallerinaCompletionContext context, List<RecordFieldSymbol> validFields) {
        Predicate<Symbol> symbolFilter = this.getVariableFilter().or(symbol -> symbol.kind() == SymbolKind.FUNCTION);
        List<Symbol> filteredSymbols = context.visibleSymbols(context.getCursorPosition()).stream().filter(symbolFilter.and(symbol -> this.isSpreadable((Symbol)symbol, validFields))).toList();
        return this.getSpreadFieldCompletionItemList(filteredSymbols, context);
    }

    private boolean isSpreadable(Symbol symbol, List<RecordFieldSymbol> fields) {
        TypeSymbol rawType;
        Optional typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
        if (typeDescriptor.isEmpty()) {
            return false;
        }
        if (typeDescriptor.get().typeKind() == TypeDescKind.FUNCTION) {
            Optional returnTypeSymbol = ((FunctionTypeSymbol)typeDescriptor.get()).returnTypeDescriptor();
            if (returnTypeSymbol.isEmpty()) {
                return false;
            }
            typeDescriptor = returnTypeSymbol;
        }
        if ((rawType = CommonUtil.getRawType(typeDescriptor.get())).typeKind() != TypeDescKind.RECORD) {
            return false;
        }
        Map recordFields = ((RecordTypeSymbol)rawType).fieldDescriptors();
        return recordFields.values().stream().allMatch(fieldSymbol -> this.isAMember((RecordFieldSymbol)fieldSymbol, fields));
    }

    private boolean isAMember(RecordFieldSymbol field, List<RecordFieldSymbol> fields) {
        return field.getName().isPresent() && fields.stream().anyMatch(validField -> validField.getName().isPresent() && ((String)validField.getName().get()).equals(field.getName().get()) && field.typeDescriptor().subtypeOf(validField.typeDescriptor()));
    }

    private List<LSCompletionItem> getSpreadFieldCompletionItemList(List<Symbol> symbols, BallerinaCompletionContext ctx) {
        ArrayList processedSymbols = new ArrayList();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        symbols.forEach(symbol -> {
            if (processedSymbols.contains(symbol)) {
                return;
            }
            Optional typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
            if (typeDescriptor.isPresent() && typeDescriptor.get().typeKind() == TypeDescKind.FUNCTION) {
                typeDescriptor = ((FunctionTypeSymbol)typeDescriptor.get()).returnTypeDescriptor();
            }
            String typeName = typeDescriptor.isEmpty() || typeDescriptor.get().typeKind() == null ? "" : NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, (TypeSymbol)typeDescriptor.get());
            CompletionItem cItem = SpreadCompletionItemBuilder.build(symbol, typeName, ctx);
            completionItems.add((LSCompletionItem)new SpreadCompletionItem(ctx, cItem, (Symbol)symbol));
            processedSymbols.add(symbol);
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getCompletionsInValueExpressionContext(BallerinaCompletionContext context) {
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            return this.getExpressionsCompletionsForQNameRef(context, qNameRef);
        }
        return this.expressionCompletions(context);
    }

    protected Map<String, RecordFieldSymbol> getValidFields(T node, RecordTypeSymbol recordTypeSymbol) {
        List<String> existingFields = this.getFields(node);
        HashMap<String, RecordFieldSymbol> fieldSymbols = new HashMap<String, RecordFieldSymbol>();
        recordTypeSymbol.fieldDescriptors().forEach((name, symbol) -> {
            if (!existingFields.contains(name)) {
                fieldSymbols.put((String)name, (RecordFieldSymbol)symbol);
            }
        });
        return fieldSymbols;
    }

    @Override
    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems) {
        Optional contextType = context.getContextType();
        if (contextType.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        completionItems.forEach(lsCItem -> {
            String sortText = SortingUtil.genSortTextByAssignability(context, lsCItem, (TypeSymbol)contextType.get());
            lsCItem.getCompletionItem().setSortText(sortText);
        });
    }
}

