/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.MatchStatementContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class MatchClauseNodeContext
extends MatchStatementContext<MatchClauseNode> {
    public MatchClauseNodeContext() {
        super(MatchClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, MatchClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, this.constantFilter());
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else if (this.onSuggestIfClause(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_IF.get()));
        } else {
            if (this.onSuggestionsAfterDoubleArrow(context, node)) {
                return completionItems;
            }
            completionItems.addAll(this.getPatternClauseCompletions(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean onSuggestionsAfterDoubleArrow(BallerinaCompletionContext context, MatchClauseNode node) {
        Token rightDoubleArrow = node.rightDoubleArrow();
        return !rightDoubleArrow.isMissing() && context.getCursorPositionInTree() >= rightDoubleArrow.textRange().endOffset();
    }

    private boolean onSuggestIfClause(BallerinaCompletionContext context, MatchClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        SeparatedNodeList matchPatterns = node.matchPatterns();
        Token rightDoubleArrow = node.rightDoubleArrow();
        return !matchPatterns.isEmpty() && cursor > matchPatterns.get(matchPatterns.size() - 1).textRange().endOffset() && (rightDoubleArrow.isMissing() || !rightDoubleArrow.isMissing() && cursor <= rightDoubleArrow.textRange().startOffset());
    }
}

