/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.MatchStatementContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class MatchStatementNodeContext
extends MatchStatementContext<MatchStatementNode> {
    public MatchStatementNodeContext() {
        super(MatchStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, MatchStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.isWithinBraces(context, node)) {
            completionItems.addAll(this.getPatternClauseCompletions(context));
        } else if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.actionKWCompletions(context));
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean isWithinBraces(BallerinaCompletionContext context, MatchStatementNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openBrace = node.openBrace();
        Token closeBrace = node.closeBrace();
        return cursor >= openBrace.textRange().endOffset() && cursor <= closeBrace.textRange().startOffset();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, MatchStatementNode node) {
        int cursor = context.getCursorPositionInTree();
        Token matchKeyword = node.matchKeyword();
        Token openBrace = node.openBrace();
        Token closeBrace = node.closeBrace();
        return !matchKeyword.isMissing() && cursor >= matchKeyword.textRange().endOffset() + 1 && (closeBrace.isMissing() || cursor < closeBrace.textRange().endOffset());
    }
}

