/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.FieldAccessContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class MethodCallExpressionNodeContext
extends FieldAccessContext<MethodCallExpressionNode> {
    public MethodCallExpressionNodeContext() {
        super(MethodCallExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, MethodCallExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinParameterContext(context, node)) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
                List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
                List<LSCompletionItem> items = this.getCompletionItemList(exprEntries, context);
                completionItems.addAll(items);
            } else {
                completionItems.addAll(this.actionKWCompletions(context));
                completionItems.addAll(this.expressionCompletions(context));
            }
        } else {
            ExpressionNode expression = node.expression();
            completionItems = this.getEntries(context, expression);
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, MethodCallExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        NameReferenceNode nameRef = node.methodName();
        Token dotToken = node.dotToken();
        return cursor <= node.textRange().endOffset() && (cursor >= nameRef.textRange().startOffset() && cursor <= nameRef.textRange().endOffset() || !dotToken.isMissing() && cursor > dotToken.textRange().startOffset());
    }

    private boolean withinParameterContext(BallerinaCompletionContext context, MethodCallExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openParen = node.openParenToken();
        Token closeParen = node.closeParenToken();
        return cursor > openParen.textRange().startOffset() && cursor < closeParen.textRange().endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, MethodCallExpressionNode node, List<LSCompletionItem> completionItems) {
        boolean withinParameterCtx = this.withinParameterContext(context, node);
        for (LSCompletionItem completionItem : completionItems) {
            this.sortByAssignability(context, completionItem, switch (completionItem.getType()) {
                case LSCompletionItem.CompletionItemType.OBJECT_FIELD, LSCompletionItem.CompletionItemType.RECORD_FIELD -> withinParameterCtx ? 1 : 2;
                case LSCompletionItem.CompletionItemType.SYMBOL -> {
                    Optional<Symbol> symbol = ((SymbolCompletionItem)completionItem).getSymbol();
                    if (symbol.stream().anyMatch(sym -> sym.kind() == SymbolKind.METHOD)) {
                        yield withinParameterCtx ? SortingUtil.toRank(context, completionItem, 2) : 1;
                    }
                    if (symbol.stream().anyMatch(sym -> sym.kind() == SymbolKind.FUNCTION)) {
                        yield withinParameterCtx ? SortingUtil.toRank(context, completionItem, 2) : 1;
                    }
                    if (symbol.stream().anyMatch(sym -> sym.kind() == SymbolKind.XMLNS)) {
                        yield withinParameterCtx ? 2 : SortingUtil.toRank(context, completionItem, 2);
                    }
                    yield SortingUtil.toRank(context, completionItem, 2);
                }
                default -> SortingUtil.toRank(context, completionItem, 2);
            });
        }
    }
}

