/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.builder.FunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.ModulePartNodeContextUtil;
import org.ballerinalang.langserver.completions.providers.context.util.ServiceTemplateGenerator;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.Position;

public class ModulePartNodeContext
extends AbstractCompletionProvider<ModulePartNode> {
    public ModulePartNodeContext() {
        super(ModulePartNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ModulePartNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ResolvedContext resolvedContext = ResolvedContext.DEFAULT;
        if (ModulePartNodeContextUtil.onServiceTypeDescContext(context.getTokenAtCursor(), context)) {
            List<Symbol> objectSymbols = ModulePartNodeContextUtil.serviceTypeDescContextSymbols(context);
            completionItems.addAll(this.getCompletionItemList(objectSymbols, context));
            completionItems.addAll(this.getModuleCompletionItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ON.get()));
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, context));
        } else if (this.onSuggestionsAfterQualifiers(context, (Node)node) && !QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, context));
            Optional<Token> lastQualifier = ModulePartNodeContextUtil.getLastQualifier(context, (Node)node);
            if (lastQualifier.isPresent() && lastQualifier.get().kind() == SyntaxKind.CONFIGURABLE_KEYWORD) {
                resolvedContext = ResolvedContext.CONFIGURABLE_QUALIFIER;
            }
        } else {
            completionItems.addAll(this.getModulePartContextItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{resolvedContext});
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        Optional<Token> lastQualifier = CommonUtil.getLastQualifier(context, node);
        if (lastQualifier.isEmpty()) {
            return completionItems;
        }
        Set qualKinds = CommonUtil.getQualifiersOfNode(context, node).stream().map(Node::kind).collect(Collectors.toSet());
        switch (lastQualifier.get().kind()) {
            case PUBLIC_KEYWORD: {
                completionItems.addAll(this.getTypeDescContextItems(context));
                List<Snippet> snippets = Arrays.asList(Snippet.KW_TYPE, Snippet.KW_ISOLATED, Snippet.KW_FINAL, Snippet.KW_CONST, Snippet.KW_LISTENER, Snippet.KW_CLIENT, Snippet.KW_VAR, Snippet.KW_ENUM, Snippet.KW_XMLNS, Snippet.KW_CLASS, Snippet.KW_TRANSACTIONAL, Snippet.DEF_FUNCTION, Snippet.DEF_EXPRESSION_BODIED_FUNCTION, Snippet.KW_CONFIGURABLE, Snippet.DEF_ANNOTATION, Snippet.DEF_RECORD, Snippet.STMT_NAMESPACE_DECLARATION, Snippet.DEF_OBJECT_SNIPPET, Snippet.DEF_CLASS, Snippet.DEF_ENUM, Snippet.DEF_CLOSED_RECORD, Snippet.DEF_ERROR_TYPE, Snippet.DEF_TABLE_TYPE_DESC, Snippet.DEF_TABLE_WITH_KEY_TYPE_DESC, Snippet.DEF_STREAM, Snippet.DEF_SERVICE_COMMON);
                snippets.forEach(snippet -> completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, snippet.get())));
                if (ModulePartNodeContextUtil.isMainFunctionUnavailable(context)) {
                    LSCompletionItem mainCompletionItem = FunctionCompletionItemBuilder.buildMainFunction(context);
                    completionItems.add(mainCompletionItem);
                }
                return completionItems;
            }
            case SERVICE_KEYWORD: 
            case CLIENT_KEYWORD: {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLASS.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_CLASS.get()));
                break;
            }
            case ISOLATED_KEYWORD: {
                if (qualKinds.contains(SyntaxKind.TRANSACTIONAL_KEYWORD)) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_EXPRESSION_BODIED_FUNCTION.get()));
                    break;
                }
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLASS.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_CLASS.get()));
                if (qualKinds.contains(SyntaxKind.SERVICE_KEYWORD) || qualKinds.contains(SyntaxKind.CLIENT_KEYWORD)) break;
                completionItems.addAll(this.getTypeDescContextItems(context));
                break;
            }
            case TRANSACTIONAL_KEYWORD: {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_EXPRESSION_BODIED_FUNCTION.get()));
                break;
            }
            case CONFIGURABLE_KEYWORD: {
                completionItems.addAll(this.getTypeDescContextItems(context));
                break;
            }
        }
        return completionItems;
    }

    @Override
    protected boolean onSuggestionsAfterQualifiers(BallerinaCompletionContext context, Node node) {
        int cursor = context.getCursorPositionInTree();
        Position cursorPos = context.getCursorPosition();
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node).stream().filter(qualifier -> qualifier.lineRange().endLine().line() == cursorPos.getLine()).toList();
        if (qualifiers.isEmpty()) {
            return false;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        return lastQualifier.textRange().endOffset() < cursor;
    }

    private List<LSCompletionItem> getModulePartContextItems(BallerinaCompletionContext context) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS;
            List<Symbol> types = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, (QualifiedNameReferenceNode)nodeAtCursor, predicate);
            completionItems.addAll(this.getCompletionItemList(types, context));
            return completionItems;
        }
        completionItems.addAll(ModulePartNodeContextUtil.getTopLevelItems(context));
        completionItems.addAll(this.getTypeDescContextItems(context));
        completionItems.addAll(ServiceTemplateGenerator.getInstance(context.languageServercontext()).getServiceTemplates(context));
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ModulePartNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        Optional<Token> lastQualifier;
        ResolvedContext resolvedContext = (ResolvedContext)((Object)metaData[0]);
        boolean onQualifiedNameIdentifier = QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor());
        if (resolvedContext != ResolvedContext.CONFIGURABLE_QUALIFIER && onQualifiedNameIdentifier && (lastQualifier = CommonUtil.getLastQualifier(context, (Node)context.getNodeAtCursor().parent().parent())).isPresent() && lastQualifier.get().kind() == SyntaxKind.CONFIGURABLE_KEYWORD) {
            resolvedContext = ResolvedContext.CONFIGURABLE_QUALIFIER;
        }
        if (resolvedContext == ResolvedContext.CONFIGURABLE_QUALIFIER) {
            SortingUtil.sortCompletionsAfterConfigurableQualifier((CompletionContext)context, completionItems, onQualifiedNameIdentifier);
        } else {
            ModulePartNodeContextUtil.sort(completionItems);
        }
    }

    static enum ResolvedContext {
        DEFAULT,
        CONFIGURABLE_QUALIFIER;

    }
}

