/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompleteExpressionValidator;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.builder.FunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.context.NodeWithRHSInitializerProvider;
import org.ballerinalang.langserver.completions.providers.context.util.ModulePartNodeContextUtil;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ModuleVariableDeclarationNodeContext
extends NodeWithRHSInitializerProvider<ModuleVariableDeclarationNode> {
    public ModuleVariableDeclarationNodeContext() {
        super(ModuleVariableDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, ModuleVariableDeclarationNode node) throws LSCompletionException {
        ResolvedContext resolvedContext;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.initializer().isPresent() && this.withinInitializerContext(ctx, node)) {
            completionItems.addAll(this.initializerContextCompletions(ctx, (Node)node.initializer().get()));
            resolvedContext = ResolvedContext.INITIALIZER;
        } else if (this.onServiceTypeDescriptorContext(ctx, node)) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)ctx.getNodeAtCursor())) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)ctx.getNodeAtCursor();
                List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)ctx, qNameRef, ModulePartNodeContextUtil.serviceTypeDescPredicate());
                completionItems.addAll(this.getCompletionItemList(moduleContent, ctx));
            } else {
                List<Symbol> objectSymbols = ModulePartNodeContextUtil.serviceTypeDescContextSymbols(ctx);
                completionItems.addAll(this.getCompletionItemList(objectSymbols, ctx));
                completionItems.addAll(this.getModuleCompletionItems(ctx));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.KW_ON.get()));
                completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, ctx));
            }
            resolvedContext = ResolvedContext.SERVICE_TYPEDESC;
        } else if (this.withinServiceOnKeywordContext(ctx, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.KW_ON.get()));
            resolvedContext = ResolvedContext.SERVICE_TYPEDESC;
        } else if (this.onSuggestionsAfterQualifiers(ctx, (Node)node) && !QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)ctx.getNodeAtCursor())) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, ctx));
            resolvedContext = ResolvedContext.ON_QUALIFIER;
        } else {
            return CompletionUtil.route(ctx, (Node)node.parent());
        }
        this.sort(ctx, node, (List<LSCompletionItem>)completionItems, new Object[]{resolvedContext});
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ModuleVariableDeclarationNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        ResolvedContext resolvedContext = (ResolvedContext)((Object)metaData[0]);
        boolean onQualifiedNameIdentifier = QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor());
        boolean hasConfigurableQualifier = this.hasConfigurableQualifier(context, node);
        if (resolvedContext != ResolvedContext.ON_QUALIFIER && onQualifiedNameIdentifier && hasConfigurableQualifier) {
            resolvedContext = ResolvedContext.ON_QUALIFIER;
        }
        if (resolvedContext == ResolvedContext.INITIALIZER) {
            super.sort(context, node, completionItems);
            return;
        }
        if (resolvedContext == ResolvedContext.ON_QUALIFIER) {
            if (hasConfigurableQualifier) {
                SortingUtil.sortCompletionsAfterConfigurableQualifier((CompletionContext)context, completionItems, onQualifiedNameIdentifier);
                return;
            }
            SortingUtil.toDefaultSorting(context, completionItems);
            return;
        }
        for (LSCompletionItem lsCItem : completionItems) {
            Object sortingText = lsCItem.getType() != LSCompletionItem.CompletionItemType.SNIPPET ? SortingUtil.genSortText(1) : SortingUtil.genSortText(2) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem));
            lsCItem.getCompletionItem().setSortText((String)sortingText);
        }
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        Optional<Token> lastQualifier = CommonUtil.getLastQualifier(context, node);
        if (lastQualifier.isEmpty()) {
            return completionItems;
        }
        Set qualKinds = CommonUtil.getQualifiersOfNode(context, node).stream().map(Node::kind).collect(Collectors.toSet());
        switch (lastQualifier.get().kind()) {
            case PUBLIC_KEYWORD: {
                completionItems.addAll(this.getTypeDescContextItems(context));
                List<Snippet> snippets = Arrays.asList(Snippet.KW_TYPE, Snippet.KW_ISOLATED, Snippet.KW_FINAL, Snippet.KW_CONST, Snippet.KW_LISTENER, Snippet.KW_CLIENT, Snippet.KW_VAR, Snippet.KW_ENUM, Snippet.KW_XMLNS, Snippet.KW_CLASS, Snippet.KW_TRANSACTIONAL, Snippet.DEF_FUNCTION, Snippet.DEF_EXPRESSION_BODIED_FUNCTION, Snippet.KW_CONFIGURABLE, Snippet.DEF_ANNOTATION, Snippet.DEF_RECORD, Snippet.STMT_NAMESPACE_DECLARATION, Snippet.DEF_OBJECT_SNIPPET, Snippet.DEF_CLASS, Snippet.DEF_ENUM, Snippet.DEF_CLOSED_RECORD, Snippet.DEF_ERROR_TYPE, Snippet.DEF_TABLE_TYPE_DESC, Snippet.DEF_TABLE_WITH_KEY_TYPE_DESC, Snippet.DEF_STREAM, Snippet.DEF_SERVICE_COMMON);
                snippets.forEach(snippet -> completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, snippet.get())));
                LSCompletionItem mainCompletionItem = FunctionCompletionItemBuilder.buildMainFunction(context);
                completionItems.add(mainCompletionItem);
                return completionItems;
            }
            case SERVICE_KEYWORD: 
            case CLIENT_KEYWORD: {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLASS.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_CLASS.get()));
                break;
            }
            case ISOLATED_KEYWORD: {
                if (qualKinds.contains(SyntaxKind.TRANSACTIONAL_KEYWORD)) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_EXPRESSION_BODIED_FUNCTION.get()));
                    break;
                }
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLASS.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_CLASS.get()));
                if (qualKinds.contains(SyntaxKind.SERVICE_KEYWORD) || qualKinds.contains(SyntaxKind.CLIENT_KEYWORD)) break;
                completionItems.addAll(this.getTypeDescContextItems(context));
                break;
            }
            case TRANSACTIONAL_KEYWORD: {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_EXPRESSION_BODIED_FUNCTION.get()));
                break;
            }
            case CONFIGURABLE_KEYWORD: {
                completionItems.addAll(this.getTypeDescContextItems(context));
                break;
            }
            case FINAL_KEYWORD: {
                completionItems.addAll(this.getTypeDescContextItems(context));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
                break;
            }
        }
        return completionItems;
    }

    private boolean withinServiceOnKeywordContext(BallerinaCompletionContext ctx, ModuleVariableDeclarationNode node) {
        List<String> leadingInvalidTokens = node.leadingInvalidTokens().stream().map(Token::text).toList();
        boolean onServiceContext = leadingInvalidTokens.contains(SyntaxKind.SERVICE_KEYWORD.stringValue());
        CompleteExpressionValidator expressionValidator = new CompleteExpressionValidator();
        int cursor = ctx.getCursorPositionInTree();
        TypeDescriptorNode typeDesc = node.typedBindingPattern().typeDescriptor();
        boolean completeTypeDesc = (Boolean)typeDesc.apply((NodeTransformer)expressionValidator);
        return onServiceContext && completeTypeDesc && cursor > typeDesc.textRange().endOffset();
    }

    private boolean onServiceTypeDescriptorContext(BallerinaCompletionContext ctx, ModuleVariableDeclarationNode node) {
        List<String> leadingInvalidTokens = node.leadingInvalidTokens().stream().map(Token::text).toList();
        boolean onServiceContext = leadingInvalidTokens.contains(SyntaxKind.SERVICE_KEYWORD.stringValue());
        CompleteExpressionValidator expressionValidator = new CompleteExpressionValidator();
        int cursor = ctx.getCursorPositionInTree();
        TypeDescriptorNode typeDesc = node.typedBindingPattern().typeDescriptor();
        boolean completeTypeDesc = (Boolean)typeDesc.apply((NodeTransformer)expressionValidator);
        return onServiceContext && (!completeTypeDesc || cursor <= typeDesc.textRange().endOffset());
    }

    private boolean withinInitializerContext(BallerinaCompletionContext context, ModuleVariableDeclarationNode node) {
        if (node.equalsToken().isEmpty()) {
            return false;
        }
        int textPosition = context.getCursorPositionInTree();
        int equalTokenEndOffset = ((Token)node.equalsToken().get()).textRange().endOffset();
        int semicolonTokenStartOffset = node.semicolonToken().textRange().startOffset();
        return equalTokenEndOffset <= textPosition && textPosition <= semicolonTokenStartOffset;
    }

    private boolean hasConfigurableQualifier(BallerinaCompletionContext context, ModuleVariableDeclarationNode node) {
        Optional<Token> lastQualifier = CommonUtil.getLastQualifier(context, (Node)node);
        return lastQualifier.isPresent() && lastQualifier.get().kind().equals((Object)SyntaxKind.CONFIGURABLE_KEYWORD);
    }

    static enum ResolvedContext {
        INITIALIZER,
        SERVICE_TYPEDESC,
        ON_QUALIFIER;

    }
}

