/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class NamedArgumentNodeContext
extends AbstractCompletionProvider<NamedArgumentNode> {
    public NamedArgumentNodeContext() {
        super(NamedArgumentNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, NamedArgumentNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)node.expression())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)node.expression();
            Predicate<Symbol> filter = symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, filter);
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
            completionItems.addAll(this.getNewExprCompletionItems(context, node));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, NamedArgumentNode node) {
        int cursor = context.getCursorPositionInTree();
        TextRange textRange = node.expression().textRange();
        return !node.equalsToken().isMissing() && cursor >= node.equalsToken().textRange().endOffset() && cursor <= textRange.endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, NamedArgumentNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbol = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.location().lineRange().endLine();
            typeSymbol = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (typeSymbol.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbol.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }

    private List<LSCompletionItem> getNewExprCompletionItems(BallerinaCompletionContext context, NamedArgumentNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional type = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.location().lineRange().endLine();
            type = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (type.isEmpty()) {
            return completionItems;
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)type.get());
        if (rawType.kind() == SymbolKind.CLASS) {
            completionItems.add(this.getImplicitNewCItemForClass((ClassSymbol)rawType, context));
        }
        return completionItems;
    }
}

