/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.TextRange;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class NamedWorkerDeclarationNodeContext
extends AbstractCompletionProvider<NamedWorkerDeclarationNode> {
    public NamedWorkerDeclarationNodeContext() {
        super(NamedWorkerDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, NamedWorkerDeclarationNode node) throws LSCompletionException {
        boolean inReturnContext = this.withinReturnTypeContext(context, node);
        if (!inReturnContext) {
            return Collections.emptyList();
        }
        if (node.returnTypeDesc().isEmpty()) {
            return Collections.singletonList(new SnippetCompletionItem(context, Snippet.KW_RETURNS.get()));
        }
        return CompletionUtil.route(context, (Node)node.returnTypeDesc().get());
    }

    private boolean withinReturnTypeContext(BallerinaCompletionContext context, NamedWorkerDeclarationNode node) {
        int textPosition = context.getCursorPositionInTree();
        TextRange nameRange = node.workerName().textRange();
        TextRange bodyStart = node.workerBody().openBraceToken().textRange();
        return nameRange.endOffset() < textPosition && textPosition < bodyStart.startOffset();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, NamedWorkerDeclarationNode node) {
        Token closeBraceToken;
        int cursor = context.getCursorPositionInTree();
        return cursor < (closeBraceToken = node.workerBody().closeBraceToken()).textRange().endOffset();
    }
}

