/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.ObjectBodiedNodeContextProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ObjectConstructorExpressionNodeContext
extends ObjectBodiedNodeContextProvider<ObjectConstructorExpressionNode> {
    public ObjectConstructorExpressionNodeContext() {
        super(ObjectConstructorExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, ObjectConstructorExpressionNode node) {
        ResolvedContext resolvedContext;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestObjectOnly(ctx, node)) {
            completionItems.addAll(Arrays.asList(new SnippetCompletionItem(ctx, Snippet.KW_OBJECT.get()), new SnippetCompletionItem(ctx, Snippet.EXPR_OBJECT_CONSTRUCTOR.get())));
            resolvedContext = ResolvedContext.OTHER;
        } else if (this.onSuggestTypeReferences(ctx, node)) {
            completionItems.addAll(this.getTypeReferenceCompletions(ctx));
            resolvedContext = ResolvedContext.TYPE_REF;
        } else {
            completionItems.addAll(this.getBodyContextItems(ctx, (Node)node));
            resolvedContext = ResolvedContext.OBJECT_CONSTRUCTOR_BODY;
        }
        this.sort(ctx, node, (List<LSCompletionItem>)completionItems, new Object[]{resolvedContext});
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ObjectConstructorExpressionNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        if (metaData == null || metaData.length != 1) {
            super.sort(context, node, completionItems, metaData);
            return;
        }
        switch (((ResolvedContext)((Object)metaData[0])).ordinal()) {
            case 0: {
                for (LSCompletionItem lsCItem : completionItems) {
                    String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
                    lsCItem.getCompletionItem().setSortText(sortText);
                }
                break;
            }
            case 1: 
            case 2: {
                super.sort(context, node, completionItems);
            }
        }
    }

    private List<LSCompletionItem> getTypeReferenceCompletions(BallerinaCompletionContext ctx) {
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.CLASS || symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == TypeDescKind.OBJECT;
        if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            return this.getCompletionItemList(QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)ctx, qNameRef, predicate), ctx);
        }
        List visibleSymbols = ctx.visibleSymbols(ctx.getCursorPosition());
        List<Symbol> objectEntries = visibleSymbols.stream().filter(predicate).toList();
        List<LSCompletionItem> completionItems = this.getCompletionItemList(objectEntries, ctx);
        completionItems.addAll(this.getModuleCompletionItems(ctx));
        return completionItems;
    }

    private boolean onSuggestObjectOnly(BallerinaCompletionContext context, ObjectConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        NodeList qualifiers = node.objectTypeQualifiers();
        if (qualifiers.isEmpty()) {
            return false;
        }
        Token objectKeyword = node.objectKeyword();
        Token lastQualifier = (Token)qualifiers.get(qualifiers.size() - 1);
        return cursor > lastQualifier.textRange().endOffset() && (objectKeyword.isMissing() || cursor < objectKeyword.textRange().startOffset());
    }

    private boolean onSuggestTypeReferences(BallerinaCompletionContext context, ObjectConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token objectKeyword = node.objectKeyword();
        Token openBrace = node.openBraceToken();
        return !objectKeyword.isMissing() && cursor > objectKeyword.textRange().startOffset() && (openBrace.isMissing() || cursor < openBrace.textRange().endOffset());
    }

    private static enum ResolvedContext {
        TYPE_REF,
        OBJECT_CONSTRUCTOR_BODY,
        OTHER;

    }
}

