/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnClauseNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.QueryExpressionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class OnClauseNodeContext
extends AbstractCompletionProvider<OnClauseNode> {
    public OnClauseNodeContext() {
        super(OnClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, OnClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (this.onSuggestEqualsKeyword(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_EQUALS.get()));
        } else if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
            if (this.cursorAtEndOfClause(context, node)) {
                completionItems.addAll(QueryExpressionUtil.getCommonKeywordCompletions(context));
            }
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, OnClauseNode node) {
        return !node.onKeyword().isMissing();
    }

    private boolean onSuggestEqualsKeyword(BallerinaCompletionContext context, OnClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        ExpressionNode lhs = node.lhsExpression();
        ExpressionNode rhs = node.rhsExpression();
        Token equalsKeyword = node.equalsKeyword();
        if (lhs.isMissing() || !equalsKeyword.isMissing()) {
            return false;
        }
        if (cursor > lhs.textRange().endOffset() && !rhs.isMissing() && cursor < rhs.textRange().startOffset()) {
            return true;
        }
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode nameReferenceNode = (SimpleNameReferenceNode)nodeAtCursor;
            return lhs.textRange().endOffset() == cursor && nameReferenceNode.textRange().endOffset() == cursor;
        }
        return false;
    }

    private boolean cursorAtEndOfClause(BallerinaCompletionContext context, OnClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        return !node.rhsExpression().isMissing() && node.rhsExpression().textRange().endOffset() < cursor;
    }
}

