/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;

public class RecordFieldNodeContext
extends AbstractCompletionProvider<RecordFieldNode> {
    public RecordFieldNodeContext() {
        super(RecordFieldNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, RecordFieldNode node) throws LSCompletionException {
        if (this.onFieldNameContext(context, node)) {
            return Collections.emptyList();
        }
        if (this.onTypeNameContext(context, node)) {
            return CompletionUtil.route(context, node.typeName());
        }
        return CompletionUtil.route(context, (Node)node.parent());
    }

    private boolean onTypeNameContext(BallerinaCompletionContext context, RecordFieldNode node) {
        int cursor = context.getCursorPositionInTree();
        int typeEnd = node.typeName().textRange().endOffset();
        int typeStart = node.typeName().textRange().startOffset();
        return cursor >= typeStart && cursor <= typeEnd;
    }

    private boolean onFieldNameContext(BallerinaCompletionContext context, RecordFieldNode node) {
        int cursor = context.getCursorPositionInTree();
        Node typeName = node.typeName();
        return !typeName.isMissing() && cursor > typeName.textRange().endOffset();
    }
}

