/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class RequiredParameterNodeContext
extends AbstractCompletionProvider<RequiredParameterNode> {
    public RequiredParameterNodeContext() {
        super(RequiredParameterNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, RequiredParameterNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            completionItems.addAll(this.getCompletionItemList(QNameRefCompletionUtil.getTypesInModule(context, qNameRef), context));
        } else if (node.typeName() instanceof FunctionTypeDescriptorNode && this.withinParamName(node, context)) {
            Optional functionSignature = ((FunctionTypeDescriptorNode)node.typeName()).functionSignature();
            if (functionSignature.isPresent() && ((FunctionSignatureNode)functionSignature.get()).returnTypeDesc().isEmpty()) {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RETURNS.get()));
            }
        } else if (!this.withinParamName(node, context)) {
            completionItems.addAll(this.getTypeDescContextItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, RequiredParameterNode node, List<LSCompletionItem> completionItems) {
        completionItems.forEach(completionItem -> {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, completionItem);
            completionItem.getCompletionItem().setSortText(sortText);
        });
    }

    private boolean withinParamName(RequiredParameterNode node, BallerinaCompletionContext context) {
        int cursor = context.getCursorPositionInTree();
        Optional paramName = node.paramName();
        return paramName.isPresent() && !((Token)paramName.get()).isMissing() && ((Token)paramName.get()).textRange().startOffset() <= cursor && cursor <= ((Token)paramName.get()).textRange().endOffset();
    }
}

