/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ResourcePathParameterNodeContext
extends AbstractCompletionProvider<ResourcePathParameterNode> {
    public ResourcePathParameterNodeContext() {
        super(ResourcePathParameterNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ResourcePathParameterNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (!this.onTypeDescContext(context, node)) {
            return completionItems;
        }
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(typesInModule, context));
        } else {
            completionItems.addAll(this.getTypeDescContextItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ResourcePathParameterNode node, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsCItem : completionItems) {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
            lsCItem.getCompletionItem().setSortText(sortText);
        }
    }

    private boolean onTypeDescContext(BallerinaCompletionContext context, ResourcePathParameterNode node) {
        int cursor = context.getCursorPositionInTree();
        TypeDescriptorNode typeDescriptor = node.typeDescriptor();
        return typeDescriptor.isMissing() || cursor <= typeDescriptor.textRange().endOffset();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ResourcePathParameterNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openBracketToken = node.openBracketToken();
        Token closeBracketToken = node.closeBracketToken();
        return !openBracketToken.isMissing() && !closeBracketToken.isMissing() && cursor > openBracketToken.textRange().startOffset() && cursor < closeBracketToken.textRange().endOffset();
    }
}

