/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.InvocationNodeContextProvider;
import org.ballerinalang.langserver.completions.util.Snippet;

public abstract class RightArrowActionNodeContext<T extends ActionNode>
extends InvocationNodeContextProvider<T> {
    public RightArrowActionNodeContext(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    protected List<LSCompletionItem> getFilteredItems(BallerinaCompletionContext context, T node, ExpressionNode expressionNode) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        Optional expressionType = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = expressionNode.location().lineRange().endLine();
            expressionType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (expressionType.isPresent() && SymbolUtil.isClient((Symbol)expressionType.get())) {
            List<MethodSymbol> clientActions = this.getClientActions((Symbol)expressionType.get());
            completionItems.addAll(this.getCompletionItemList(clientActions, context));
        } else {
            List<Symbol> filteredWorkers = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.WORKER).toList();
            completionItems.addAll(this.getCompletionItemList(filteredWorkers, context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
        }
        return completionItems;
    }

    public List<MethodSymbol> getClientActions(Symbol symbol) {
        if (!SymbolUtil.isObject(symbol)) {
            return new ArrayList<MethodSymbol>();
        }
        TypeSymbol typeDescriptor = CommonUtil.getRawType(SymbolUtil.getTypeDescriptor(symbol).orElseThrow());
        return ((ObjectTypeSymbol)typeDescriptor).methods().values().stream().filter(method -> method.qualifiers().contains(Qualifier.REMOTE) || method.qualifiers().contains(Qualifier.RESOURCE)).toList();
    }
}

