/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;

public class TableTypeDescriptorNodeContext
extends AbstractCompletionProvider<TableTypeDescriptorNode> {
    public TableTypeDescriptorNodeContext() {
        super(TableTypeDescriptorNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, TableTypeDescriptorNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestKeyKw(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_KEY.get()));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean onSuggestKeyKw(BallerinaCompletionContext context, TableTypeDescriptorNode node) {
        boolean shouldSuggest;
        int cursor = context.getCursorPositionInTree();
        Optional keyConstraint = node.keyConstraintNode();
        Node rowTypeParamNode = node.rowTypeParameterNode();
        boolean bl = shouldSuggest = keyConstraint.isEmpty() && cursor >= rowTypeParamNode.textRange().endOffset() || keyConstraint.isPresent() && cursor <= ((Node)keyConstraint.get()).textRange().startOffset() && cursor >= rowTypeParamNode.textRange().endOffset();
        if (!shouldSuggest || node.rowTypeParameterNode().kind() != SyntaxKind.TYPE_PARAMETER) {
            return false;
        }
        TypeParameterNode typeParameterNode = (TypeParameterNode)node.rowTypeParameterNode();
        Optional symbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)typeParameterNode.typeNode()));
        if (symbol.isEmpty()) {
            return false;
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType((TypeSymbol)symbol.get());
        return typeSymbol.typeKind() == TypeDescKind.RECORD || CommonUtil.isUnionOfType(typeSymbol, TypeDescKind.RECORD);
    }
}

