/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class TypeCastExpressionNodeContext
extends AbstractCompletionProvider<TypeCastExpressionNode> {
    public TypeCastExpressionNodeContext() {
        super(TypeCastExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, TypeCastExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(typesInModule, context));
        } else {
            completionItems.addAll(this.getTypeDescContextItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, TypeCastExpressionNode node) {
        int gtTokenEnd;
        int cursor = context.getCursorPositionInTree();
        return cursor <= (gtTokenEnd = node.gtToken().textRange().endOffset());
    }

    @Override
    public void sort(BallerinaCompletionContext context, TypeCastExpressionNode node, List<LSCompletionItem> completionItems) {
        completionItems.forEach(lsCItem -> {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
            lsCItem.getCompletionItem().setSortText(sortText);
        });
    }
}

