/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.wso2.ballerinalang.compiler.util.Names;

public class WaitActionNodeContext
extends AbstractCompletionProvider<WaitActionNode> {
    public WaitActionNodeContext() {
        super(WaitActionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, WaitActionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol instanceof VariableSymbol;
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> filteredList = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
            completionItems.addAll(this.getCompletionItemList(filteredList, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getModuleCompletionItems(context));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_SERVICE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_NEW.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_LET.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TYPEOF.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRAP.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ERROR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLIENT.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_OBJECT.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CHECK.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CHECK_PANIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_IS.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_ERROR_CONSTRUCTOR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_OBJECT_CONSTRUCTOR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_BASE16_LITERAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_BASE64_LITERAL.get()));
        List<Symbol> filteredList = visibleSymbols.stream().filter(symbol -> (symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.PARAMETER || symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.WORKER) && !symbol.getName().orElse("").equals(Names.ERROR.getValue())).toList();
        completionItems.addAll(this.getCompletionItemList(filteredList, context));
        this.getAnonFunctionDefSnippet(context).ifPresent(completionItems::add);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, WaitActionNode node, List<LSCompletionItem> completionItems) {
        Optional contextType = context.getContextType();
        for (LSCompletionItem lsCompletionItem : completionItems) {
            int rank;
            CompletionItem completionItem = lsCompletionItem.getCompletionItem();
            if (this.isValidSymbolCompletionItem(lsCompletionItem)) {
                SymbolCompletionItem symbolCompletionItem = (SymbolCompletionItem)lsCompletionItem;
                Symbol symbol = symbolCompletionItem.getSymbol().get();
                if (symbol.kind() == SymbolKind.WORKER) {
                    rank = 1;
                } else if (symbol.kind() == SymbolKind.VARIABLE && ((VariableSymbol)symbol).typeDescriptor().typeKind() == TypeDescKind.FUTURE && contextType.isPresent() && ((TypeSymbol)contextType.get()).typeKind() == TypeDescKind.FUTURE) {
                    Optional completionItemTypeSymbol = ((FutureTypeSymbol)((VariableSymbol)symbol).typeDescriptor()).typeParameter();
                    Optional contextTypeSymbol = ((FutureTypeSymbol)contextType.get()).typeParameter();
                    rank = completionItemTypeSymbol.isPresent() && contextTypeSymbol.isPresent() && ((TypeSymbol)completionItemTypeSymbol.get()).subtypeOf((TypeSymbol)contextTypeSymbol.get()) ? 1 : 2;
                } else {
                    rank = SortingUtil.toRank(context, lsCompletionItem, 2);
                }
            } else {
                rank = SortingUtil.toRank(context, lsCompletionItem, 2);
            }
            completionItem.setSortText(SortingUtil.genSortText(rank));
        }
    }

    private boolean isValidSymbolCompletionItem(LSCompletionItem lsCompletionItem) {
        return lsCompletionItem instanceof SymbolCompletionItem && ((SymbolCompletionItem)lsCompletionItem).getSymbol().isPresent();
    }
}

