/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context.util;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.builder.FunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SnippetBlock;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public final class ModulePartNodeContextUtil {
    private ModulePartNodeContextUtil() {
    }

    public static List<LSCompletionItem> getTopLevelItems(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList<Snippet> snippets = new ArrayList<Snippet>(Arrays.asList(Snippet.KW_TYPE, Snippet.KW_PUBLIC, Snippet.KW_ISOLATED, Snippet.KW_FINAL, Snippet.KW_CONST, Snippet.KW_LISTENER, Snippet.KW_CLIENT, Snippet.KW_VAR, Snippet.KW_ENUM, Snippet.KW_XMLNS, Snippet.KW_CLASS, Snippet.KW_TRANSACTIONAL, Snippet.DEF_FUNCTION, Snippet.DEF_EXPRESSION_BODIED_FUNCTION, Snippet.KW_CONFIGURABLE, Snippet.DEF_ANNOTATION, Snippet.DEF_RECORD, Snippet.STMT_NAMESPACE_DECLARATION, Snippet.DEF_OBJECT_SNIPPET, Snippet.DEF_CLASS, Snippet.DEF_ENUM, Snippet.DEF_CLOSED_RECORD, Snippet.DEF_ERROR_TYPE, Snippet.DEF_TABLE_TYPE_DESC, Snippet.DEF_TABLE_WITH_KEY_TYPE_DESC, Snippet.DEF_STREAM, Snippet.DEF_SERVICE_COMMON));
        if (ModulePartNodeContextUtil.isInImportStatementsContext(context)) {
            snippets.add(Snippet.KW_IMPORT);
        }
        snippets.forEach(snippet -> completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, snippet.get())));
        if (ModulePartNodeContextUtil.isMainFunctionUnavailable(context)) {
            LSCompletionItem mainCompletionItem = FunctionCompletionItemBuilder.buildMainFunction(context);
            completionItems.add(mainCompletionItem);
        }
        return completionItems;
    }

    public static boolean isMainFunctionUnavailable(BallerinaCompletionContext context) {
        Optional<ModulePartNode> modulePartNode = context.currentSyntaxTree().map(SyntaxTree::rootNode);
        return modulePartNode.filter(partNode -> context.visibleSymbols(PositionUtil.toPosition(partNode.lineRange().startLine())).stream().anyMatch(symbol -> symbol.kind() == SymbolKind.FUNCTION && symbol.nameEquals("main"))).isEmpty();
    }

    private static boolean isInImportStatementsContext(BallerinaCompletionContext context) {
        Optional syntaxTree = context.currentSyntaxTree();
        Optional<ModulePartNode> modulePartNode = syntaxTree.map(SyntaxTree::rootNode);
        if (syntaxTree.isEmpty() || modulePartNode.isEmpty()) {
            return false;
        }
        int cursor = context.getCursorPositionInTree();
        return modulePartNode.get().members().stream().noneMatch(moduleMemberDeclarationNode -> moduleMemberDeclarationNode.kind() != SyntaxKind.IMPORT_DECLARATION && PositionUtil.getPositionOffset(PositionUtil.toPosition(moduleMemberDeclarationNode.lineRange().endLine()), (SyntaxTree)syntaxTree.get()) < cursor);
    }

    public static void sort(List<LSCompletionItem> items) {
        for (LSCompletionItem item : items) {
            CompletionItem cItem = item.getCompletionItem();
            if (ModulePartNodeContextUtil.isSnippetBlock(item)) {
                SnippetCompletionItem snippetCompletionItem = (SnippetCompletionItem)item;
                if (snippetCompletionItem.id().equals(Snippet.DEF_SERVICE_COMMON.name())) {
                    cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(2));
                    continue;
                }
                if (snippetCompletionItem.id().equals(Snippet.DEF_FUNCTION.name())) {
                    cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(5));
                    continue;
                }
                if (snippetCompletionItem.id().equals(Snippet.DEF_CLOSED_RECORD.name())) {
                    cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(6));
                    continue;
                }
                if (snippetCompletionItem.id().equals(Snippet.DEF_RECORD.name())) {
                    cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(7));
                    continue;
                }
                cItem.setSortText(SortingUtil.genSortText(2));
                continue;
            }
            if (ModulePartNodeContextUtil.isServiceTemplate(item)) {
                cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(3));
                continue;
            }
            if (SortingUtil.isTypeCompletionItem(item)) {
                if (SortingUtil.isLangLibModuleCompletionItem(item)) {
                    cItem.setSortText(SortingUtil.genSortText(3) + SortingUtil.genSortText(2));
                    continue;
                }
                cItem.setSortText(SortingUtil.genSortText(3) + SortingUtil.genSortText(1));
                continue;
            }
            if (ModulePartNodeContextUtil.isKeyword(item)) {
                SnippetCompletionItem snippet = (SnippetCompletionItem)item;
                if (Snippet.KW_SERVICE.name().equals(snippet.id()) || Snippet.KW_FUNCTION.name().equals(snippet.id())) {
                    cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(4));
                    continue;
                }
                cItem.setSortText(SortingUtil.genSortText(4));
                continue;
            }
            if (SortingUtil.isLangLibModuleCompletionItem(item)) {
                cItem.setSortText(SortingUtil.genSortText(5));
                continue;
            }
            if (SortingUtil.isModuleCompletionItem(item)) {
                cItem.setSortText(SortingUtil.genSortText(6));
                continue;
            }
            if (item instanceof StaticCompletionItem && ((StaticCompletionItem)item).kind() == StaticCompletionItem.Kind.MAIN_FUNCTION) {
                cItem.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(1));
                continue;
            }
            cItem.setSortText(SortingUtil.genSortText(7));
        }
    }

    public static boolean onServiceTypeDescContext(Token evalToken, BallerinaCompletionContext context) {
        Optional<Minutiae> tokenValueAtCursor = ModulePartNodeContextUtil.findTokenValueInMinutiae(evalToken);
        int cursor = context.getCursorPositionInTree();
        return evalToken.text().equals(SyntaxKind.SERVICE_KEYWORD.stringValue()) && cursor > evalToken.textRange().endOffset() || tokenValueAtCursor.isPresent() && tokenValueAtCursor.get().text().equals(SyntaxKind.SERVICE_KEYWORD.stringValue()) && tokenValueAtCursor.get().textRange().endOffset() < cursor;
    }

    public static List<Symbol> serviceTypeDescContextSymbols(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        return visibleSymbols.stream().filter(ModulePartNodeContextUtil.serviceTypeDescPredicate()).toList();
    }

    public static Predicate<Symbol> serviceTypeDescPredicate() {
        return symbol -> {
            if (symbol.kind() == SymbolKind.CLASS) {
                return true;
            }
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
                return false;
            }
            Optional<TypeSymbol> objSymbol = SymbolUtil.getTypeDescriptor(symbol);
            return objSymbol.isPresent() && CommonUtil.getRawType(objSymbol.get()).typeKind() == TypeDescKind.OBJECT;
        };
    }

    private static boolean isSnippetBlock(LSCompletionItem completionItem) {
        return completionItem instanceof SnippetCompletionItem && (((SnippetCompletionItem)completionItem).kind() == SnippetBlock.Kind.SNIPPET || ((SnippetCompletionItem)completionItem).kind() == SnippetBlock.Kind.STATEMENT);
    }

    private static boolean isKeyword(LSCompletionItem completionItem) {
        return completionItem instanceof SnippetCompletionItem && ((SnippetCompletionItem)completionItem).kind() == SnippetBlock.Kind.KEYWORD;
    }

    private static boolean isServiceTemplate(LSCompletionItem completionItem) {
        return completionItem.getType() == LSCompletionItem.CompletionItemType.STATIC && ((StaticCompletionItem)completionItem).kind() == StaticCompletionItem.Kind.SERVICE_TEMPLATE;
    }

    private static Optional<Minutiae> findTokenValueInMinutiae(Token evalToken) {
        ArrayList tokensFromMinutiae = new ArrayList();
        evalToken.leadingMinutiae().forEach(minutiae -> {
            if (minutiae.kind() != SyntaxKind.WHITESPACE_MINUTIAE && minutiae.kind() != SyntaxKind.END_OF_LINE_MINUTIAE) {
                tokensFromMinutiae.add(minutiae);
            }
        });
        return !tokensFromMinutiae.isEmpty() ? Optional.of((Minutiae)tokensFromMinutiae.get(tokensFromMinutiae.size() - 1)) : Optional.empty();
    }

    public static Optional<Token> getLastQualifier(BallerinaCompletionContext context, Node node) {
        Position cursorPos = context.getCursorPosition();
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node).stream().filter(qualifier -> qualifier.lineRange().endLine().line() == cursorPos.getLine()).toList();
        if (qualifiers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(qualifiers.get(qualifiers.size() - 1));
    }
}

