/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.StringTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingMatchPatternNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.common.utils.TypeResolverUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.completions.util.FieldAccessCompletionResolver;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class ContextTypeResolver
extends NodeTransformer<Optional<TypeSymbol>> {
    private final PositionedOperationContext context;
    private final List<Node> visitedNodes = new ArrayList<Node>();

    public ContextTypeResolver(PositionedOperationContext context) {
        this.context = context;
    }

    public Optional<TypeSymbol> transform(ListenerDeclarationNode node) {
        Optional typeDesc = node.typeDescriptor();
        if (typeDesc.isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((TypeDescriptorNode)typeDesc.get()).apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(SimpleNameReferenceNode node) {
        Optional<Symbol> symbol = this.getSymbolByName(node.name().text());
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(symbol.get());
    }

    public Optional<TypeSymbol> transform(SpecificFieldNode node) {
        Optional parentType = (Optional)node.parent().apply((NodeTransformer)new ContextTypeResolver(this.context));
        if (parentType.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol parentRawType = CommonUtil.getRawType((TypeSymbol)parentType.get());
        if (parentRawType.typeKind() == TypeDescKind.MAP) {
            TypeSymbol rawContextType = this.getRawContextType((TypeSymbol)parentType.get());
            return Optional.of(rawContextType);
        }
        if (parentRawType.typeKind() != TypeDescKind.RECORD || node.fieldName().kind() != SyntaxKind.STRING_LITERAL && node.fieldName().kind() != SyntaxKind.IDENTIFIER_TOKEN) {
            return Optional.empty();
        }
        if (node.fieldName().kind() == SyntaxKind.STRING_LITERAL) {
            return Optional.of(parentRawType);
        }
        RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)parentRawType;
        String fieldName = ((IdentifierToken)node.fieldName()).text();
        Optional<TypeSymbol> typeOfField = recordTypeSymbol.fieldDescriptors().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(fieldName)).findFirst().map(entry -> ((RecordFieldSymbol)entry.getValue()).typeDescriptor());
        return typeOfField.isEmpty() ? Optional.empty() : Optional.of(typeOfField.get());
    }

    public Optional<TypeSymbol> transform(AssignmentStatementNode node) {
        return this.visit(node.varRef());
    }

    public Optional<TypeSymbol> transform(QualifiedNameReferenceNode node) {
        Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && (symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS) && ((String)symbol.getName().get()).equals(node.identifier().text());
        List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent(this.context, node, predicate);
        if (moduleContent.size() != 1) {
            return Optional.empty();
        }
        Symbol symbol2 = moduleContent.get(0);
        if (symbol2.kind() == SymbolKind.CLASS) {
            ClassSymbol classSymbol = (ClassSymbol)symbol2;
            return Optional.of(classSymbol);
        }
        TypeSymbol typeDescriptor = ((TypeDefinitionSymbol)symbol2).typeDescriptor();
        return Optional.of(typeDescriptor);
    }

    public Optional<TypeSymbol> transform(VariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(LetVariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(ObjectFieldNode node) {
        Optional symbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)node));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.CLASS_FIELD) {
            return Optional.empty();
        }
        ClassFieldSymbol classFieldSymbol = (ClassFieldSymbol)symbol.get();
        return Optional.of(this.getRawContextType(classFieldSymbol.typeDescriptor()));
    }

    public Optional<TypeSymbol> transform(ModuleVariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(IndexedExpressionNode node) {
        Optional containerType = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
        if (containerType.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)containerType.get()));
    }

    public Optional<TypeSymbol> transform(CaptureBindingPatternNode node) {
        Optional<Symbol> variableSymbol = this.getSymbolByName(node.variableName().text());
        Optional typeSymbol = variableSymbol.flatMap(SymbolUtil::getTypeDescriptor);
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)typeSymbol.get()));
    }

    public Optional<TypeSymbol> transform(AnnotationNode node) {
        Optional<Symbol> annotationSymbol;
        Node annotationRef = node.annotReference();
        Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && symbol.kind() == SymbolKind.ANNOTATION;
        if (annotationRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)annotationRef;
            Predicate<Symbol> qNamePredicate = predicate.and(symbol -> ((String)symbol.getName().get()).equals(qNameRef.identifier().text()));
            annotationSymbol = this.getTypeFromQNameReference(qNameRef, qNamePredicate);
        } else if (annotationRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            annotationSymbol = this.getSymbolByName(((SimpleNameReferenceNode)annotationRef).name().text(), predicate);
        } else {
            return Optional.empty();
        }
        if (annotationSymbol.isEmpty()) {
            return Optional.empty();
        }
        return ((AnnotationSymbol)annotationSymbol.get()).typeDescriptor();
    }

    public Optional<TypeSymbol> transform(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        Optional semanticModel = this.context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return Optional.empty();
        }
        Optional typeRefSymbol = ((SemanticModel)semanticModel.get()).typeOf((Node)errorConstructorExpressionNode);
        if (typeRefSymbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType((TypeSymbol)typeRefSymbol.get());
        if (typeSymbol.typeKind() != TypeDescKind.ERROR) {
            return Optional.empty();
        }
        return Optional.ofNullable(CommonUtil.getRawType(((ErrorTypeSymbol)typeSymbol).detailTypeDescriptor()));
    }

    public Optional<TypeSymbol> transform(FunctionDefinitionNode node) {
        Optional returnTypeDesc = node.functionSignature().returnTypeDesc();
        if (returnTypeDesc.isEmpty() || this.context.currentSemanticModel().isEmpty()) {
            return Optional.empty();
        }
        Optional functionSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).symbol((Node)node);
        if (functionSymbol.isEmpty()) {
            return Optional.empty();
        }
        return ((FunctionSymbol)functionSymbol.get()).typeDescriptor().returnTypeDescriptor();
    }

    public Optional<TypeSymbol> transform(FieldAccessExpressionNode node) {
        FieldAccessCompletionResolver resolver = new FieldAccessCompletionResolver(this.context);
        List<Symbol> visibleEntries = resolver.getVisibleEntries((Node)node.expression());
        NameReferenceNode nameRef = node.fieldName();
        if (nameRef.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        String fieldName = ((SimpleNameReferenceNode)nameRef).name().text();
        Optional<Symbol> filteredSymbol = visibleEntries.stream().filter(symbol -> symbol.getName().isPresent() && ((String)symbol.getName().get()).equals(fieldName)).findFirst();
        if (filteredSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(filteredSymbol.get());
    }

    public Optional<TypeSymbol> transform(FunctionCallExpressionNode node) {
        Optional<Object> funcSymbol = Optional.empty();
        NameReferenceNode nameRef = node.functionName();
        if (nameRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nameRef;
            Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && symbol.kind() == SymbolKind.FUNCTION;
            Predicate<Symbol> qNamePredicate = predicate.and(symbol -> symbol.getName().orElse("").equals(qNameRef.identifier().text()));
            funcSymbol = this.getTypeFromQNameReference(qNameRef, qNamePredicate);
        } else if (nameRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            funcSymbol = this.getSymbolByName(((SimpleNameReferenceNode)nameRef).name().text());
        }
        if (funcSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (!TypeResolverUtil.isInFunctionCallParameterContext(node, this.context.getCursorPositionInTree()).booleanValue() || !(funcSymbol.get() instanceof FunctionSymbol)) {
            return SymbolUtil.getTypeDescriptor((Symbol)funcSymbol.get());
        }
        return TypeResolverUtil.resolveParameterTypeSymbol(((FunctionSymbol)funcSymbol.get()).typeDescriptor(), (NodeList<FunctionArgumentNode>)node.arguments(), this.context.getCursorPositionInTree());
    }

    public Optional<TypeSymbol> transform(ImplicitNewExpressionNode implicitNewExpressionNode) {
        Optional<Object> classSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)implicitNewExpressionNode)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst();
        if (classSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (!TypeResolverUtil.isInNewExpressionParameterContext(implicitNewExpressionNode, this.context.getCursorPositionInTree()).booleanValue()) {
            return SymbolUtil.getTypeDescriptor((Symbol)classSymbol.get());
        }
        if (((TypeSymbol)classSymbol.get()).typeKind() == TypeDescKind.UNION && (classSymbol = ((UnionTypeSymbol)classSymbol.get()).memberTypeDescriptors().stream().filter(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.OBJECT).map(CommonUtil::getRawType).findFirst()).isEmpty()) {
            return Optional.empty();
        }
        if (!(classSymbol.get() instanceof ClassSymbol)) {
            return Optional.of((TypeSymbol)classSymbol.get());
        }
        Optional args = implicitNewExpressionNode.parenthesizedArgList();
        if (args.isEmpty()) {
            return Optional.empty();
        }
        Optional methodSymbol = ((ClassSymbol)classSymbol.get()).initMethod();
        if (methodSymbol.isEmpty() || implicitNewExpressionNode.parenthesizedArgList().isEmpty()) {
            return Optional.empty();
        }
        return TypeResolverUtil.resolveParameterTypeSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), (NodeList<FunctionArgumentNode>)((ParenthesizedArgList)implicitNewExpressionNode.parenthesizedArgList().get()).arguments(), this.context.getCursorPositionInTree());
    }

    public Optional<TypeSymbol> transform(ExplicitNewExpressionNode explicitNewExpressionNode) {
        Optional<Object> classSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)explicitNewExpressionNode)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst();
        if (classSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (!TypeResolverUtil.isInNewExpressionParameterContext(explicitNewExpressionNode, this.context.getCursorPositionInTree()).booleanValue()) {
            return SymbolUtil.getTypeDescriptor((Symbol)classSymbol.get());
        }
        if (((TypeSymbol)classSymbol.get()).typeKind() == TypeDescKind.UNION && (classSymbol = ((UnionTypeSymbol)classSymbol.get()).memberTypeDescriptors().stream().filter(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.OBJECT).map(CommonUtil::getRawType).findFirst()).isEmpty()) {
            return Optional.empty();
        }
        if (!(classSymbol.get() instanceof ClassSymbol)) {
            return Optional.of((TypeSymbol)classSymbol.get());
        }
        Optional methodSymbol = ((ClassSymbol)classSymbol.get()).initMethod();
        if (methodSymbol.isEmpty()) {
            return Optional.empty();
        }
        return TypeResolverUtil.resolveParameterTypeSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), (NodeList<FunctionArgumentNode>)explicitNewExpressionNode.parenthesizedArgList().arguments(), this.context.getCursorPositionInTree());
    }

    public Optional<TypeSymbol> transform(MethodCallExpressionNode node) {
        if (node.methodName().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        SimpleNameReferenceNode methodName = (SimpleNameReferenceNode)node.methodName();
        FieldAccessCompletionResolver resolver = new FieldAccessCompletionResolver(this.context);
        List<Symbol> visibleEntries = resolver.getVisibleEntries((Node)node.expression());
        Optional<Symbol> methodSymbol = visibleEntries.stream().filter(symbol -> symbol.getName().orElse("").equals(methodName.name().text())).findFirst();
        if (methodSymbol.isEmpty() || methodSymbol.get().kind() != SymbolKind.METHOD && methodSymbol.get().kind() != SymbolKind.FUNCTION) {
            return Optional.empty();
        }
        if (!TypeResolverUtil.isInMethodCallParameterContext(node, this.context.getCursorPositionInTree()).booleanValue()) {
            return SymbolUtil.getTypeDescriptor(methodSymbol.get());
        }
        return TypeResolverUtil.getPositionalArgumentTypeForFunction((NodeList<FunctionArgumentNode>)node.arguments(), (NonTerminalNode)node, (DocumentServiceContext)this.context, this.context.getCursorPositionInTree());
    }

    public Optional<TypeSymbol> transform(RemoteMethodCallActionNode node) {
        Optional methodSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).symbol((Node)node);
        if (methodSymbol.isEmpty() || ((Symbol)methodSymbol.get()).kind() != SymbolKind.METHOD) {
            return Optional.empty();
        }
        if (!TypeResolverUtil.isInMethodCallParameterContext(node, this.context.getCursorPositionInTree()).booleanValue()) {
            return (Optional)node.parent().apply((NodeTransformer)this);
        }
        return TypeResolverUtil.resolveParameterTypeSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), (NodeList<FunctionArgumentNode>)node.arguments(), this.context.getCursorPositionInTree());
    }

    public Optional<TypeSymbol> transform(PositionalArgumentNode positionalArgumentNode) {
        switch (positionalArgumentNode.parent().kind()) {
            case FUNCTION_CALL: {
                return TypeResolverUtil.getPositionalArgumentTypeForFunction((NodeList<FunctionArgumentNode>)((FunctionCallExpressionNode)positionalArgumentNode.parent()).arguments(), positionalArgumentNode.parent(), (DocumentServiceContext)this.context, this.context.getCursorPositionInTree());
            }
            case METHOD_CALL: {
                return TypeResolverUtil.getPositionalArgumentTypeForFunction((NodeList<FunctionArgumentNode>)((MethodCallExpressionNode)positionalArgumentNode.parent()).arguments(), positionalArgumentNode.parent(), (DocumentServiceContext)this.context, this.context.getCursorPositionInTree());
            }
            case REMOTE_METHOD_CALL_ACTION: {
                return TypeResolverUtil.getPositionalArgumentTypeForFunction((NodeList<FunctionArgumentNode>)((RemoteMethodCallActionNode)positionalArgumentNode.parent()).arguments(), positionalArgumentNode.parent(), (DocumentServiceContext)this.context, this.context.getCursorPositionInTree());
            }
            case PARENTHESIZED_ARG_LIST: {
                ParenthesizedArgList parenthesizedArgList = (ParenthesizedArgList)positionalArgumentNode.parent();
                switch (parenthesizedArgList.parent().kind()) {
                    case IMPLICIT_NEW_EXPRESSION: {
                        ImplicitNewExpressionNode implicitNewExpressionNode = (ImplicitNewExpressionNode)parenthesizedArgList.parent();
                        Optional argList = implicitNewExpressionNode.parenthesizedArgList();
                        if (argList.isEmpty()) {
                            return Optional.empty();
                        }
                        return TypeResolverUtil.getPositionalArgumentTypeForNewExpr((NodeList<FunctionArgumentNode>)((ParenthesizedArgList)argList.get()).arguments(), (NewExpressionNode)implicitNewExpressionNode, (DocumentServiceContext)this.context, this.context.getCursorPositionInTree());
                    }
                    case EXPLICIT_NEW_EXPRESSION: {
                        ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)parenthesizedArgList.parent();
                        return TypeResolverUtil.getPositionalArgumentTypeForNewExpr((NodeList<FunctionArgumentNode>)explicitNewExpressionNode.parenthesizedArgList().arguments(), (NewExpressionNode)explicitNewExpressionNode, (DocumentServiceContext)this.context, this.context.getCursorPositionInTree());
                    }
                }
            }
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(NamedArgumentNode namedArgumentNode) {
        switch (namedArgumentNode.parent().kind()) {
            case FUNCTION_CALL: 
            case METHOD_CALL: 
            case REMOTE_METHOD_CALL_ACTION: {
                NonTerminalNode parentNode = namedArgumentNode.parent();
                Optional parameterSymbols = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)parentNode)).filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD || symbol.kind() == SymbolKind.RESOURCE_METHOD).flatMap(symbol -> ((FunctionSymbol)symbol).typeDescriptor().params());
                if (parameterSymbols.isEmpty()) {
                    return Optional.empty();
                }
                for (ParameterSymbol parameterSymbol : (List)parameterSymbols.get()) {
                    if (!parameterSymbol.getName().map(name -> name.equals(namedArgumentNode.argumentName().name().text())).orElse(false).booleanValue()) continue;
                    TypeSymbol typeDescriptor = parameterSymbol.typeDescriptor();
                    return Optional.of(typeDescriptor);
                }
                break;
            }
            case ERROR_CONSTRUCTOR: {
                Optional<TypeSymbol> errorDetail = this.visit((Node)namedArgumentNode.parent());
                if (errorDetail.isEmpty() || errorDetail.get().typeKind() != TypeDescKind.RECORD) {
                    return Optional.empty();
                }
                Optional<RecordFieldSymbol> fieldSymbol = ((RecordTypeSymbol)errorDetail.get()).fieldDescriptors().values().stream().filter(recordFieldSymbol -> recordFieldSymbol.getName().isPresent() && namedArgumentNode.argumentName().name().text().trim().equals(recordFieldSymbol.getName().get())).findFirst();
                if (!fieldSymbol.isPresent()) break;
                return Optional.of(fieldSymbol.get().typeDescriptor());
            }
            case PARENTHESIZED_ARG_LIST: {
                return this.visit((Node)namedArgumentNode.parent());
            }
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(ListConstructorExpressionNode node) {
        Optional<TypeSymbol> typeSymbol = this.visit((Node)node.parent());
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol.get());
        if (rawType.typeKind() != TypeDescKind.ARRAY) {
            return Optional.empty();
        }
        TypeSymbol memberType = ((ArrayTypeSymbol)rawType).memberTypeDescriptor();
        return Optional.of(memberType);
    }

    public Optional<TypeSymbol> transform(DefaultableParameterNode node) {
        Optional symbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)node));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.PARAMETER) {
            return Optional.empty();
        }
        ParameterSymbol parameterSymbol = (ParameterSymbol)symbol.get();
        TypeSymbol typeDescriptor = parameterSymbol.typeDescriptor();
        return Optional.of(typeDescriptor);
    }

    public Optional<TypeSymbol> transform(ExplicitAnonymousFunctionExpressionNode node) {
        Optional returnTypeDesc = node.functionSignature().returnTypeDesc();
        if (returnTypeDesc.isEmpty() || this.context.currentSemanticModel().isEmpty()) {
            return Optional.empty();
        }
        Optional typeSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).symbol(((ReturnTypeDescriptorNode)returnTypeDesc.get()).type());
        if (typeSymbol.isEmpty() || ((Symbol)typeSymbol.get()).kind() != SymbolKind.TYPE) {
            return Optional.empty();
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbol.get();
        return Optional.of(symbol);
    }

    public Optional<TypeSymbol> transform(ImplicitAnonymousFunctionExpressionNode node) {
        Optional<TypeSymbol> typeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node)).or(() -> (Optional)node.parent().apply((NodeTransformer)this));
        if (typeSymbol.isEmpty() || ((TypeSymbol)typeSymbol.get()).typeKind() != TypeDescKind.FUNCTION) {
            return Optional.empty();
        }
        FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)typeSymbol.get();
        if (!node.rightDoubleArrow().isMissing() && this.context.getCursorPositionInTree() >= node.rightDoubleArrow().textRange().endOffset()) {
            return functionTypeSymbol.returnTypeDescriptor();
        }
        return typeSymbol;
    }

    public Optional<TypeSymbol> transform(RecordFieldWithDefaultValueNode node) {
        Optional symbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol(node.typeName()));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.TYPE) {
            return Optional.empty();
        }
        return Optional.of(this.getRawContextType((TypeSymbol)symbol.get()));
    }

    public Optional<TypeSymbol> transform(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)mappingConstructorExpressionNode)).filter(typeSymbol -> typeSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR).or(() -> (Optional)mappingConstructorExpressionNode.parent().apply((NodeTransformer)this));
    }

    public Optional<TypeSymbol> transform(MappingMatchPatternNode mappingMatchPatternNode) {
        return (Optional)mappingMatchPatternNode.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(MatchClauseNode matchClauseNode) {
        return (Optional)matchClauseNode.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(MatchStatementNode matchStatementNode) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)matchStatementNode.condition()));
    }

    public Optional<TypeSymbol> transform(TableConstructorExpressionNode node) {
        Optional<TypeSymbol> optionalTypeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node)).filter(tSymbol -> tSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR).or(() -> (Optional)node.parent().apply((NodeTransformer)this)).filter(tSymbol -> tSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR);
        if (optionalTypeSymbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType(optionalTypeSymbol.get());
        if (typeSymbol.typeKind() != TypeDescKind.TABLE) {
            return Optional.of(typeSymbol);
        }
        if (node.keySpecifier().isPresent() && ((KeySpecifierNode)node.keySpecifier().get()).textRange().startOffset() < this.context.getCursorPositionInTree() && this.context.getCursorPositionInTree() < ((KeySpecifierNode)node.keySpecifier().get()).textRange().endOffset()) {
            typeSymbol = ((TableTypeSymbol)typeSymbol).rowTypeParameter();
        } else if (node.openBracket().textRange().endOffset() < this.context.getCursorPositionInTree() && this.context.getCursorPositionInTree() < node.closeBracket().textRange().startOffset()) {
            typeSymbol = ((TableTypeSymbol)typeSymbol).rowTypeParameter();
        }
        return Optional.of(typeSymbol);
    }

    public Optional<TypeSymbol> transform(SelectClauseNode node) {
        Optional<TypeSymbol> typeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node.expression())).filter(tSymbol -> tSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR).or(() -> (Optional)node.parent().apply((NodeTransformer)this)).filter(tSymbol -> tSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR);
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        return switch (typeSymbol.get().typeKind()) {
            case TypeDescKind.TABLE -> Optional.of(((TableTypeSymbol)typeSymbol.get()).rowTypeParameter());
            case TypeDescKind.STREAM -> Optional.of(((StreamTypeSymbol)typeSymbol.get()).typeParameter());
            case TypeDescKind.ARRAY -> Optional.of(((ArrayTypeSymbol)typeSymbol.get()).memberTypeDescriptor());
            default -> typeSymbol;
        };
    }

    public Optional<TypeSymbol> transform(FromClauseNode fromClauseNode) {
        if (this.context.currentSemanticModel().isEmpty()) {
            return Optional.empty();
        }
        if (this.context.getCursorPositionInTree() > fromClauseNode.inKeyword().textRange().endOffset()) {
            Optional<TypeSymbol> typeSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).typeOf((Node)fromClauseNode.expression());
            if (typeSymbol.isPresent()) {
                return typeSymbol;
            }
            Optional optionalSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).symbol((Node)fromClauseNode.typedBindingPattern().bindingPattern());
            if (optionalSymbol.isEmpty()) {
                return Optional.empty();
            }
            typeSymbol = SymbolUtil.getTypeDescriptor((Symbol)optionalSymbol.get());
            if (typeSymbol.isEmpty() || typeSymbol.get().typeKind() == TypeDescKind.COMPILATION_ERROR) {
                return Optional.empty();
            }
            return Optional.of(this.buildUnionOfIterables(typeSymbol.get(), (SemanticModel)this.context.currentSemanticModel().get()));
        }
        Optional optionalSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).symbol((Node)fromClauseNode.typedBindingPattern().bindingPattern());
        if (optionalSymbol.isEmpty()) {
            Optional typeSymbol = ((SemanticModel)this.context.currentSemanticModel().get()).typeOf((Node)fromClauseNode.expression());
            if (typeSymbol.isEmpty()) {
                return typeSymbol;
            }
            switch (((TypeSymbol)typeSymbol.get()).typeKind()) {
                case ARRAY: {
                    return Optional.of(((ArrayTypeSymbol)typeSymbol.get()).memberTypeDescriptor());
                }
                case STRING: {
                    return Optional.of(((SemanticModel)this.context.currentSemanticModel().get()).types().STRING);
                }
                case TABLE: {
                    return Optional.of(((TableTypeSymbol)typeSymbol.get()).rowTypeParameter());
                }
                case STREAM: {
                    return Optional.of(((StreamTypeSymbol)typeSymbol.get()).typeParameter());
                }
                case XML: {
                    return Optional.of(((SemanticModel)this.context.currentSemanticModel().get()).types().XML);
                }
                case MAP: {
                    return Optional.of(((MapTypeSymbol)typeSymbol.get()).typeParam());
                }
            }
        }
        return Optional.empty();
    }

    private UnionTypeSymbol buildUnionOfIterables(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        Types types = semanticModel.types();
        TypeBuilder builder = types.builder();
        ArrayList<StreamTypeSymbol> unionTypeMembers = new ArrayList<StreamTypeSymbol>(List.of(builder.ARRAY_TYPE.withType(typeSymbol).build(), builder.MAP_TYPE.withTypeParam(typeSymbol).build(), builder.STREAM_TYPE.withValueType(typeSymbol).build()));
        if (CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.RECORD) {
            try {
                unionTypeMembers.add((StreamTypeSymbol)builder.TABLE_TYPE.withRowType(CommonUtil.getRawType(typeSymbol)).build());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (typeSymbol instanceof StringTypeSymbol) {
            unionTypeMembers.add((StreamTypeSymbol)types.STRING);
        }
        if (typeSymbol.typeKind() == TypeDescKind.XML) {
            unionTypeMembers.add((StreamTypeSymbol)types.XML);
        }
        return builder.UNION_TYPE.withMemberTypes((TypeSymbol[])unionTypeMembers.toArray(TypeSymbol[]::new)).build();
    }

    protected Optional<TypeSymbol> transformSyntaxNode(Node node) {
        return this.visit((Node)node.parent());
    }

    private Optional<Symbol> getTypeFromQNameReference(QualifiedNameReferenceNode node, Predicate<Symbol> predicate) {
        List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent(this.context, node, predicate);
        if (moduleContent.size() != 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(moduleContent.get(0));
    }

    private Optional<TypeSymbol> visit(Node node) {
        if (node == null || this.visitedNodes.contains(node)) {
            return Optional.empty();
        }
        this.visitedNodes.add(node);
        return (Optional)node.apply((NodeTransformer)this);
    }

    private Optional<Symbol> getSymbolByName(String name) {
        return this.context.visibleSymbols(this.context.getCursorPosition()).stream().filter(symbol -> symbol.getName().orElse("").equals(name)).findFirst();
    }

    private Optional<Symbol> getSymbolByName(String name, @Nonnull Predicate<Symbol> predicate) {
        Predicate<Symbol> namePredicate = symbol -> symbol.getName().orElse("").equals(name);
        return this.context.visibleSymbols(this.context.getCursorPosition()).stream().filter(namePredicate.and(predicate)).findFirst();
    }

    private TypeSymbol getRawContextType(TypeSymbol typeSymbol) {
        TypeSymbol rawType = typeSymbol;
        switch (typeSymbol.typeKind()) {
            case MAP: {
                rawType = ((MapTypeSymbol)rawType).typeParam();
                break;
            }
            case TABLE: {
                rawType = ((TableTypeSymbol)rawType).rowTypeParameter();
                break;
            }
        }
        return rawType;
    }
}

