/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;

public final class QNameRefCompletionUtil {
    private QNameRefCompletionUtil() {
    }

    public static List<Symbol> getExpressionContextEntries(BallerinaCompletionContext ctx, QualifiedNameReferenceNode qNameRef) {
        return QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef.modulePrefix().text());
    }

    public static List<Symbol> getExpressionContextEntries(BallerinaCompletionContext ctx, String moduleAlias) {
        String alias = QNameRefCompletionUtil.getAlias(moduleAlias);
        Optional<ModuleSymbol> moduleSymbol = ModuleUtil.searchModuleForAlias((PositionedOperationContext)ctx, alias);
        return moduleSymbol.map(value -> value.allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS || symbol instanceof VariableSymbol).toList()).orElseGet(Collections::emptyList);
    }

    public static String getAlias(QualifiedNameReferenceNode qNameRef) {
        String alias = qNameRef.modulePrefix().text();
        return QNameRefCompletionUtil.getAlias(alias);
    }

    private static String getAlias(String alias) {
        return alias.startsWith("'") ? alias.substring(1) : alias;
    }

    public static List<Symbol> getModuleContent(PositionedOperationContext context, QualifiedNameReferenceNode qNameRef, Predicate<Symbol> predicate) {
        Optional<ModuleSymbol> module = ModuleUtil.searchModuleForAlias(context, QNameRefCompletionUtil.getAlias(qNameRef));
        return module.map(moduleSymbol -> moduleSymbol.allSymbols().stream().filter(predicate).toList()).orElseGet(Collections::emptyList);
    }

    public static List<Symbol> getTypesInModule(BallerinaCompletionContext context, QualifiedNameReferenceNode qNameRef) {
        Optional<ModuleSymbol> module = ModuleUtil.searchModuleForAlias((PositionedOperationContext)context, QNameRefCompletionUtil.getAlias(qNameRef));
        return module.map(symbol -> symbol.allSymbols().stream().filter(CommonUtil.typesFilter()).toList()).orElseGet(Collections::emptyList);
    }

    public static boolean onQualifiedNameIdentifier(PositionedOperationContext context, Node node) {
        int cursor;
        if (node.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)node;
        int colonPos = qNameRef.colon().textRange().startOffset();
        return colonPos < (cursor = context.getCursorPositionInTree()) && (qNameRef.identifier().isMissing() || cursor <= qNameRef.identifier().textRange().endOffset());
    }

    public static boolean onModulePrefix(PositionedOperationContext context, Node node) {
        if (node.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        int colonPos = ((QualifiedNameReferenceNode)node).colon().textRange().startOffset();
        int cursor = context.getCursorPositionInTree();
        return cursor <= colonPos;
    }
}

