/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.util.Optional;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.commons.BallerinaDefinitionContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.contexts.AbstractDocumentServiceContext;
import org.ballerinalang.langserver.contexts.BallerinaContextUtils;
import org.ballerinalang.langserver.contexts.PositionedOperationContextImpl;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class BallerinaDefinitionContextImpl
extends PositionedOperationContextImpl
implements BallerinaDefinitionContext {
    private boolean capturedEnclosingNode = false;
    private ModuleMemberDeclarationNode enclosingNode = null;

    BallerinaDefinitionContextImpl(LSOperation operation, String fileUri, WorkspaceManager wsManager, Position position, LanguageServerContext serverContext, CancelChecker cancelChecker) {
        super(operation, fileUri, position, wsManager, serverContext, cancelChecker);
    }

    public Optional<ModuleMemberDeclarationNode> enclosedModuleMember() {
        if (!this.capturedEnclosingNode) {
            this.capturedEnclosingNode = true;
            Optional<SyntaxTree> syntaxTree = this.currentSyntaxTree();
            if (syntaxTree.isEmpty()) {
                throw new RuntimeException("Cannot find a valid syntax tree");
            }
            this.enclosingNode = BallerinaContextUtils.getEnclosingModuleMember(syntaxTree.get(), this.getCursorPositionInTree()).orElse(null);
        }
        return Optional.ofNullable(this.enclosingNode);
    }

    protected static class DefinitionContextBuilder
    extends AbstractDocumentServiceContext.AbstractContextBuilder<DefinitionContextBuilder> {
        private Position cursor;

        public DefinitionContextBuilder(LanguageServerContext serverContext) {
            super(LSContextOperation.TXT_DEFINITION, serverContext);
        }

        public DefinitionContextBuilder withCursorPosition(Position position) {
            this.cursor = position;
            return this.self();
        }

        public BallerinaDefinitionContext build() {
            return new BallerinaDefinitionContextImpl(this.operation, this.fileUri, this.wsManager, this.cursor, this.serverContext, this.cancelChecker);
        }

        @Override
        public DefinitionContextBuilder self() {
            return this;
        }
    }
}

