/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.contexts.AbstractDocumentServiceContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class CodeActionContextImpl
extends AbstractDocumentServiceContext
implements CodeActionContext {
    private Position cursorPosition;
    private int cursorPositionInTree = -1;
    private List<Diagnostic> diagnostics;
    private final CodeActionParams params;
    private Node nodeAtCursor;
    private Node nodeAtRange;

    @Deprecated(forRemoval=true)
    public CodeActionContextImpl(LSOperation operation, String fileUri, WorkspaceManager wsManager, CodeActionParams params, LanguageServerContext serverContext) {
        super(operation, fileUri, wsManager, serverContext);
        this.params = params;
    }

    public CodeActionContextImpl(LSOperation operation, String fileUri, WorkspaceManager wsManager, CodeActionParams params, LanguageServerContext serverContext, CancelChecker cancelChecker) {
        super(operation, fileUri, wsManager, serverContext, cancelChecker);
        this.params = params;
    }

    public Position cursorPosition() {
        if (this.cursorPosition == null) {
            int line = this.params.getRange().getStart().getLine();
            int col = this.params.getRange().getStart().getCharacter();
            this.cursorPosition = new Position(line, col);
        }
        return this.cursorPosition;
    }

    public List<Diagnostic> diagnostics(Path filePath) {
        this.checkCancelled();
        if (this.diagnostics != null) {
            return this.diagnostics;
        }
        PackageCompilation compilation = this.getCancelChecker().isPresent() ? (PackageCompilation)this.workspace().waitAndGetPackageCompilation(filePath, this.getCancelChecker().get()).orElseThrow() : (PackageCompilation)this.workspace().waitAndGetPackageCompilation(filePath).orElseThrow();
        Project project = (Project)this.workspace().project(this.filePath()).orElseThrow();
        Path projectRoot = project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? project.sourceRoot().getParent() : project.sourceRoot();
        this.diagnostics = compilation.diagnosticResult().diagnostics().stream().filter(diag -> projectRoot.resolve(diag.location().lineRange().fileName()).equals(filePath)).toList();
        return this.diagnostics;
    }

    public List<org.eclipse.lsp4j.Diagnostic> cursorDiagnostics() {
        return this.params.getContext().getDiagnostics();
    }

    public int cursorPositionInTree() {
        if (this.cursorPositionInTree == -1) {
            Optional<Document> document = this.currentDocument();
            if (document.isEmpty()) {
                return this.cursorPositionInTree;
            }
            TextDocument textDocument = document.get().textDocument();
            Position position = this.cursorPosition();
            this.cursorPositionInTree = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        }
        return this.cursorPositionInTree;
    }

    public Node nodeAtCursor() {
        if (this.nodeAtCursor == null) {
            SyntaxTree syntaxTree = this.currentSyntaxTree().orElseThrow();
            NonTerminalNode matchedNode = CommonUtil.findNode(new Range(this.cursorPosition(), this.cursorPosition()), syntaxTree);
            this.nodeAtCursor = matchedNode;
        }
        return this.nodeAtCursor;
    }

    public Range range() {
        return this.params.getRange();
    }

    public Node nodeAtRange() {
        if (this.nodeAtRange == null) {
            SyntaxTree syntaxTree = this.currentSyntaxTree().orElseThrow();
            this.nodeAtRange = CommonUtil.findNode(this.range(), syntaxTree);
        }
        return this.nodeAtRange;
    }

    protected static class CodeActionContextBuilder
    extends AbstractDocumentServiceContext.AbstractContextBuilder<CodeActionContextBuilder> {
        private final CodeActionParams params;

        public CodeActionContextBuilder(CodeActionParams params, LanguageServerContext serverContext) {
            super(LSContextOperation.TXT_CODE_ACTION, serverContext);
            this.params = params;
        }

        public CodeActionContext build() {
            return new CodeActionContextImpl(this.operation, this.fileUri, this.wsManager, this.params, this.serverContext, this.cancelChecker);
        }

        @Override
        public CodeActionContextBuilder self() {
            return this;
        }
    }
}

