/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import io.ballerina.compiler.api.symbols.Symbol;
import java.util.List;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.contexts.AbstractDocumentServiceContext;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public abstract class PositionedOperationContextImpl
extends AbstractDocumentServiceContext
implements PositionedOperationContext {
    private final Position cursorPosition;
    private int cursorPositionInTree = -1;
    private List<Symbol> visibleSymbols;

    PositionedOperationContextImpl(LSOperation operation, String fileUri, Position cursorPosition, WorkspaceManager wsManager, LanguageServerContext serverContext, CancelChecker cancelChecker) {
        super(operation, fileUri, wsManager, serverContext, cancelChecker);
        this.cursorPosition = cursorPosition;
    }

    @Override
    public List<Symbol> visibleSymbols(Position position) {
        if (this.cursorPosition.equals((Object)position)) {
            if (this.visibleSymbols == null) {
                this.visibleSymbols = super.visibleSymbols(position);
            }
            return this.visibleSymbols;
        }
        return super.visibleSymbols(position);
    }

    public void setCursorPositionInTree(int offset) {
        if (this.cursorPositionInTree > -1) {
            throw new RuntimeException("Setting the cursor offset more than once is not allowed");
        }
        this.cursorPositionInTree = offset;
    }

    public int getCursorPositionInTree() {
        return this.cursorPositionInTree;
    }

    public Position getCursorPosition() {
        return this.cursorPosition;
    }

    protected static abstract class PositionedOperationContextBuilder<T extends DocumentServiceContext>
    extends AbstractDocumentServiceContext.AbstractContextBuilder<PositionedOperationContextBuilder<T>> {
        protected Position position;

        public PositionedOperationContextBuilder(LSContextOperation operation, LanguageServerContext serverContext) {
            super(operation, serverContext);
        }

        public PositionedOperationContextBuilder<T> withPosition(Position position) {
            this.position = position;
            return this.self();
        }

        public abstract T build();

        @Override
        public PositionedOperationContextBuilder<T> self() {
            return this;
        }
    }
}

