/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.definition;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaDefinitionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class DefinitionUtil {
    private DefinitionUtil() {
    }

    public static List<org.eclipse.lsp4j.Location> getDefinition(BallerinaDefinitionContext context, Position position) {
        Optional<org.eclipse.lsp4j.Location> location;
        DefinitionUtil.fillTokenInfoAtCursor(context);
        context.checkCancelled();
        Optional srcFile = context.currentDocument();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty() || srcFile.isEmpty()) {
            return Collections.emptyList();
        }
        LinePosition linePosition = LinePosition.from((int)position.getLine(), (int)position.getCharacter());
        Optional symbol = ((SemanticModel)semanticModel.get()).symbol((Document)srcFile.get(), linePosition);
        context.checkCancelled();
        if (symbol.isEmpty()) {
            return Collections.emptyList();
        }
        if (context.enclosedModuleMember().isPresent() && SymbolUtil.isSelfClassSymbol((Symbol)symbol.get(), (PositionedOperationContext)context, (ModuleMemberDeclarationNode)context.enclosedModuleMember().get())) {
            TypeSymbol rawType = CommonUtil.getRawType(((VariableSymbol)symbol.get()).typeDescriptor());
            location = DefinitionUtil.getLocation((Symbol)rawType, context);
        } else {
            location = DefinitionUtil.getLocation((Symbol)symbol.get(), context);
        }
        return location.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static Optional<org.eclipse.lsp4j.Location> getLocation(Symbol symbol, BallerinaDefinitionContext context) {
        String fileUri;
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty() || symbol.getModule().isEmpty() || symbol.getLocation().isEmpty()) {
            return Optional.empty();
        }
        Optional<Path> filepath = PathUtil.getFilePathForSymbol(symbol, (Project)project.get(), (DocumentServiceContext)context);
        if (filepath.isEmpty() || symbol.getLocation().isEmpty()) {
            return Optional.empty();
        }
        Path absFilePath = filepath.get().normalize().toAbsolutePath();
        if (PathUtil.isWriteProtectedPath(absFilePath)) {
            try {
                fileUri = PathUtil.getBalaUriForPath(context.languageServercontext(), absFilePath);
            }
            catch (URISyntaxException e) {
                throw new UserErrorException("Unable create definition file URI");
            }
        } else {
            fileUri = absFilePath.toUri().toString();
        }
        Location symbolLocation = (Location)symbol.getLocation().get();
        LinePosition startLine = symbolLocation.lineRange().startLine();
        LinePosition endLine = symbolLocation.lineRange().endLine();
        Position start = new Position(startLine.line(), startLine.offset());
        Position end = new Position(endLine.line(), endLine.offset());
        Range range = new Range(start, end);
        return Optional.of(new org.eclipse.lsp4j.Location(fileUri, range));
    }

    private static void fillTokenInfoAtCursor(BallerinaDefinitionContext context) {
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            throw new RuntimeException("Could not find a valid document");
        }
        TextDocument textDocument = ((Document)document.get()).textDocument();
        Position position = context.getCursorPosition();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
    }
}

