/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.documentsymbol;

import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleXMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.commons.DocumentSymbolContext;
import org.ballerinalang.langserver.documentsymbol.DocumentSymbolUtil;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;

public class DocumentSymbolResolver
extends NodeTransformer<Optional<DocumentSymbol>> {
    private final List<DocumentSymbol> documentSymbolStore;
    private final DocumentSymbolContext context;

    DocumentSymbolResolver(DocumentSymbolContext context) {
        this.context = context;
        this.documentSymbolStore = new ArrayList<DocumentSymbol>();
    }

    public List<DocumentSymbol> getDocumentSymbolStore() {
        return this.documentSymbolStore;
    }

    public Optional<DocumentSymbol> transform(Token token) {
        return Optional.empty();
    }

    protected Optional<DocumentSymbol> transformSyntaxNode(Node node) {
        return Optional.empty();
    }

    public Optional<DocumentSymbol> transform(ModulePartNode modulePartNode) {
        ArrayList memberSymbols = new ArrayList();
        for (ModuleMemberDeclarationNode member : modulePartNode.members()) {
            ((Optional)member.apply((NodeTransformer)this)).ifPresent(memberSymbols::add);
        }
        if (this.context.getHierarchicalDocumentSymbolSupport()) {
            this.documentSymbolStore.addAll(memberSymbols);
        }
        return Optional.empty();
    }

    public Optional<DocumentSymbol> transform(FunctionDefinitionNode functionDefinitionNode) {
        SymbolKind symbolKind;
        Object name = "";
        Range range = DocumentSymbolUtil.generateNodeRange((Node)functionDefinitionNode);
        Optional metadata = functionDefinitionNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        switch (functionDefinitionNode.kind()) {
            case FUNCTION_DEFINITION: {
                name = functionDefinitionNode.functionName().text();
                symbolKind = SymbolKind.Function;
                break;
            }
            case OBJECT_METHOD_DEFINITION: {
                name = functionDefinitionNode.functionName().text();
                if ("init".equals(name)) {
                    symbolKind = SymbolKind.Constructor;
                    break;
                }
                symbolKind = SymbolKind.Method;
                break;
            }
            case RESOURCE_ACCESSOR_DEFINITION: {
                String accessor = functionDefinitionNode.functionName().text();
                ArrayList<String> pathParams = new ArrayList<String>();
                String resourcePath = "";
                for (Node child : functionDefinitionNode.children()) {
                    if (child.kind() == SyntaxKind.IDENTIFIER_TOKEN && !((IdentifierToken)child).text().equals(accessor)) {
                        resourcePath = ((IdentifierToken)child).text();
                        continue;
                    }
                    if (child.kind() == SyntaxKind.RESOURCE_PATH_SEGMENT_PARAM) {
                        String[] param2 = child.toSourceCode().replaceAll("\\[|\\]", "").split("\\s+");
                        pathParams.add(param2[param2.length - 1]);
                        continue;
                    }
                    if (child.kind() != SyntaxKind.RESOURCE_PATH_REST_PARAM) continue;
                    pathParams.add("*");
                }
                if (!accessor.isEmpty()) {
                    name = accessor + ":" + resourcePath;
                    if (!pathParams.isEmpty()) {
                        String params = pathParams.stream().map(param -> "{" + param + "}").collect(Collectors.joining("/"));
                        name = (String)name + (String)(resourcePath.isEmpty() ? params : "/" + params);
                    } else if (resourcePath.isEmpty()) {
                        name = (String)name + "/";
                    }
                }
                symbolKind = SymbolKind.Function;
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        if (name == null || ((String)name).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.createDocumentSymbol((String)name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(MethodDeclarationNode methodDeclarationNode) {
        String name = methodDeclarationNode.methodName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Method;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)methodDeclarationNode);
        Optional metadata = methodDeclarationNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(ClassDefinitionNode classDefinitionNode) {
        String name = classDefinitionNode.className().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Class;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)classDefinitionNode);
        Optional metadata = classDefinitionNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        List<DocumentSymbol> children = this.transformMembers((NodeList<? extends Node>)classDefinitionNode.members());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, children));
    }

    public Optional<DocumentSymbol> transform(ServiceDeclarationNode serviceDeclarationNode) {
        StringBuilder name = new StringBuilder("service");
        name.append(" ").append(serviceDeclarationNode.absoluteResourcePath().stream().map(Node::toSourceCode).collect(Collectors.joining("")));
        SymbolKind symbolKind = SymbolKind.Object;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)serviceDeclarationNode);
        Optional metadata = serviceDeclarationNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        List<DocumentSymbol> children = this.transformMembers((NodeList<? extends Node>)serviceDeclarationNode.members());
        return Optional.of(this.createDocumentSymbol(name.toString(), symbolKind, range, range, isDeprecated, children));
    }

    public Optional<DocumentSymbol> transform(TypeDefinitionNode typeDefinitionNode) {
        SymbolKind symbolKind;
        String name = typeDefinitionNode.typeName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        Node typeDescriptor = typeDefinitionNode.typeDescriptor();
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        switch (typeDescriptor.kind()) {
            case RECORD_TYPE_DESC: {
                symbolKind = SymbolKind.Struct;
                RecordTypeDescriptorNode recordTypeDescriptorNode = (RecordTypeDescriptorNode)typeDescriptor;
                children.addAll(this.transformMembers((NodeList<? extends Node>)recordTypeDescriptorNode.fields()));
                Optional restTypeDec = recordTypeDescriptorNode.recordRestDescriptor();
                if (!restTypeDec.isPresent()) break;
                Optional restDocSymbol = (Optional)((RecordRestDescriptorNode)restTypeDec.get()).apply((NodeTransformer)this);
                restDocSymbol.ifPresent(children::add);
                break;
            }
            case OBJECT_TYPE_DESC: {
                symbolKind = SymbolKind.Interface;
                children.addAll(this.transformMembers((NodeList<? extends Node>)((ObjectTypeDescriptorNode)typeDescriptor).members()));
                break;
            }
            default: {
                symbolKind = SymbolKind.TypeParameter;
            }
        }
        Range range = DocumentSymbolUtil.generateNodeRange((Node)typeDefinitionNode);
        Optional metadata = typeDefinitionNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, children));
    }

    public Optional<DocumentSymbol> transform(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        BindingPatternNode bindingPatternNode = moduleVariableDeclarationNode.typedBindingPattern().bindingPattern();
        if (bindingPatternNode.kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) {
            return Optional.empty();
        }
        String name = bindingPatternNode.toSourceCode();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Variable;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)moduleVariableDeclarationNode);
        Optional metadata = moduleVariableDeclarationNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(ConstantDeclarationNode constantDeclarationNode) {
        String name = constantDeclarationNode.variableName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Constant;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)constantDeclarationNode);
        Optional metadata = constantDeclarationNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(EnumDeclarationNode enumDeclarationNode) {
        String name = enumDeclarationNode.identifier().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Enum;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)enumDeclarationNode);
        Optional metadata = enumDeclarationNode.metadata();
        List<DocumentSymbol> children = this.transformMembers((NodeList<? extends Node>)enumDeclarationNode.enumMemberList());
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, children));
    }

    public Optional<DocumentSymbol> transform(ModuleXMLNamespaceDeclarationNode moduleXMLNamespaceDeclarationNode) {
        String name;
        Optional prefix = moduleXMLNamespaceDeclarationNode.namespacePrefix();
        String string = name = prefix.isPresent() ? ((IdentifierToken)prefix.get()).text() : SyntaxKind.XMLNS_KEYWORD.stringValue() + " " + moduleXMLNamespaceDeclarationNode.namespaceuri().toSourceCode();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Namespace;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)moduleXMLNamespaceDeclarationNode);
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(ListenerDeclarationNode listenerDeclarationNode) {
        String name = listenerDeclarationNode.variableName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Object;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)listenerDeclarationNode);
        Optional metadata = listenerDeclarationNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(AnnotationDeclarationNode annotationDeclarationNode) {
        String name = annotationDeclarationNode.annotationTag().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Property;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)annotationDeclarationNode);
        Optional metadata = annotationDeclarationNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(ObjectFieldNode objectFieldNode) {
        String name = objectFieldNode.fieldName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Field;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)objectFieldNode);
        Optional metadata = objectFieldNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(RecordFieldNode recordFieldNode) {
        String name = recordFieldNode.fieldName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Field;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)recordFieldNode);
        Optional metadata = recordFieldNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(RecordFieldWithDefaultValueNode recordFieldWithDefaultValueNode) {
        String name = recordFieldWithDefaultValueNode.fieldName().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Field;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)recordFieldWithDefaultValueNode);
        Optional metadata = recordFieldWithDefaultValueNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(RecordRestDescriptorNode recordRestDescriptorNode) {
        String name = recordRestDescriptorNode.ellipsisToken().text() + recordRestDescriptorNode.typeName().toSourceCode().trim();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.Field;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)recordRestDescriptorNode);
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, Collections.emptyList()));
    }

    public Optional<DocumentSymbol> transform(EnumMemberNode enumMemberNode) {
        String name = enumMemberNode.identifier().text();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        SymbolKind symbolKind = SymbolKind.EnumMember;
        Range range = DocumentSymbolUtil.generateNodeRange((Node)enumMemberNode);
        Optional metadata = enumMemberNode.metadata();
        boolean isDeprecated = metadata.isPresent() && DocumentSymbolUtil.isDeprecated((MetadataNode)metadata.get());
        return Optional.of(this.createDocumentSymbol(name, symbolKind, range, range, isDeprecated, Collections.emptyList()));
    }

    private List<DocumentSymbol> transformMembers(NodeList<? extends Node> nodes) {
        ArrayList<DocumentSymbol> childSymbols = new ArrayList<DocumentSymbol>();
        nodes.forEach(node -> ((Optional)node.apply((NodeTransformer)this)).ifPresent(childSymbols::add));
        return childSymbols;
    }

    private DocumentSymbol createDocumentSymbol(String name, SymbolKind kind, Range range, Range selectionRange, List<DocumentSymbol> children) {
        return this.createDocumentSymbol(name, kind, null, range, selectionRange, false, children);
    }

    private DocumentSymbol createDocumentSymbol(String name, SymbolKind kind, Range range, Range selectionRange, boolean isDeprecated, List<DocumentSymbol> children) {
        return this.createDocumentSymbol(name, kind, null, range, selectionRange, isDeprecated, children);
    }

    private DocumentSymbol createDocumentSymbol(String name, SymbolKind kind, String detail, Range range, Range selectionRange, boolean isDeprecated, List<DocumentSymbol> children) {
        DocumentSymbol documentSymbol = new DocumentSymbol();
        documentSymbol.setName(name);
        documentSymbol.setKind(kind);
        documentSymbol.setDetail(detail);
        documentSymbol.setRange(range);
        documentSymbol.setSelectionRange(selectionRange);
        if (isDeprecated && this.context.deprecatedSupport()) {
            documentSymbol.setTags(List.of(SymbolTag.Deprecated));
        }
        if (this.context.getHierarchicalDocumentSymbolSupport()) {
            documentSymbol.setChildren(children);
        } else {
            this.documentSymbolStore.add(documentSymbol);
        }
        return documentSymbol;
    }
}

