/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.eventsync.publishers;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.eventsync.EventKind;
import org.ballerinalang.langserver.eventsync.AbstractEventPublisher;

public class ProjectUpdateEventPublisher
extends AbstractEventPublisher {
    public static final String NAME = "Project update event publisher";
    private CompletableFuture<Boolean> latestScheduled = null;
    private static final long DIAGNOSTIC_DELAY = 1L;

    @Override
    public EventKind getKind() {
        return EventKind.PROJECT_UPDATE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void publish(ExtendedLanguageClient client, LanguageServerContext serverContext, DocumentServiceContext context) {
        if (this.latestScheduled != null && !this.latestScheduled.isDone()) {
            this.latestScheduled.completeExceptionally(new Throwable("Cancelled project update event publisher"));
        }
        Executor delayedExecutor = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        CompletableFuture<Boolean> scheduledFuture = CompletableFuture.supplyAsync(() -> true, delayedExecutor);
        this.latestScheduled = scheduledFuture;
        scheduledFuture.thenAcceptAsync(aBoolean -> this.subscribers.parallelStream().forEach(subscriber -> subscriber.onEvent(client, context, serverContext)));
    }
}

