/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManagerProxy;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManagerProxy;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManagerProxyImpl;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageServer;

public abstract class AbstractExtendedLanguageServer
implements LanguageServer,
Endpoint,
JsonRpcMethodProvider {
    protected List<ExtendedLanguageServerService> extendedServices = new ArrayList<ExtendedLanguageServerService>();
    private Map<String, JsonRpcMethod> supportedMethods;
    private final Multimap<String, Endpoint> extensionServices = LinkedListMultimap.create();
    protected final LanguageServerContext serverContext;
    protected BallerinaWorkspaceManagerProxy workspaceManagerProxy;

    public AbstractExtendedLanguageServer(LanguageServerContext serverContext) {
        this.workspaceManagerProxy = new BallerinaWorkspaceManagerProxyImpl(serverContext);
        this.serverContext = serverContext;
        ServiceLoader<ExtendedLanguageServerService> serviceLoader = ServiceLoader.load(ExtendedLanguageServerService.class);
        for (ExtendedLanguageServerService service : serviceLoader) {
            this.extendedServices.add(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        Multimap<String, Endpoint> multimap = this.extensionServices;
        synchronized (multimap) {
            LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>(ServiceEndpoints.getSupportedMethods(this.getClass()));
            LinkedHashMap<String, JsonRpcMethod> extensions = new LinkedHashMap<String, JsonRpcMethod>();
            for (ExtendedLanguageServerService ext : this.extendedServices) {
                if (ext == null) continue;
                ext.init((LanguageServer)this, (WorkspaceManagerProxy)this.workspaceManagerProxy, this.serverContext);
                Map supportedExtensions = ext.supportedMethods();
                for (Map.Entry entry : supportedExtensions.entrySet()) {
                    if (supportedMethods.containsKey(entry.getKey())) {
                        String msg = "The json rpc method '" + (String)entry.getKey() + "' can not be an extension as it is already defined in the LSP standard.";
                        LSClientLogger.getInstance(this.serverContext).logError(null, msg, new RuntimeException(msg), null, new Position[]{null});
                        continue;
                    }
                    JsonRpcMethod existing = extensions.put((String)entry.getKey(), (JsonRpcMethod)entry.getValue());
                    if (existing != null && !Objects.equal((Object)existing, entry.getValue())) {
                        String msg = "An incompatible LSP extension '" + (String)entry.getKey() + "' has already been registered. Using 1 ignoring 2. \n1 : " + String.valueOf(existing) + " \n2 : " + String.valueOf(entry.getValue());
                        LSClientLogger.getInstance(this.serverContext).logError(null, msg, new RuntimeException(msg), null, new Position[]{null});
                        extensions.put((String)entry.getKey(), existing);
                        continue;
                    }
                    Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)ext);
                    this.extensionServices.put((Object)((String)entry.getKey()), (Object)endpoint);
                    supportedMethods.put((String)entry.getKey(), (JsonRpcMethod)entry.getValue());
                }
            }
            this.supportedMethods = supportedMethods;
            return supportedMethods;
        }
    }

    public void notify(String method, Object parameter) {
        for (Endpoint endpoint : this.extensionServices.get((Object)method)) {
            endpoint.notify(method, parameter);
        }
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        if (!this.extensionServices.containsKey((Object)method)) {
            throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
        }
        Iterator iterator = this.extensionServices.get((Object)method).iterator();
        if (iterator.hasNext()) {
            Endpoint endpoint = (Endpoint)iterator.next();
            return endpoint.request(method, parameter);
        }
        return null;
    }

    public WorkspaceManager getWorkspaceManager() {
        return this.workspaceManagerProxy.get();
    }

    public LanguageServerContext getServerContext() {
        return this.serverContext;
    }
}

