/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.connector;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.Settings;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.EnvironmentBuilder;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.repos.TempDirCompilationCache;
import io.ballerina.projects.util.ProjectUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.model.ConnectorInfo;
import org.ballerinalang.diagramutil.DiagramUtil;
import org.ballerinalang.diagramutil.connector.generator.ConnectorGenerator;
import org.ballerinalang.diagramutil.connector.models.connector.Connector;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.exception.LSConnectorException;
import org.ballerinalang.langserver.extensions.ballerina.connector.BallerinaConnectorListRequest;
import org.ballerinalang.langserver.extensions.ballerina.connector.BallerinaConnectorListResponse;
import org.ballerinalang.langserver.extensions.ballerina.connector.BallerinaConnectorRequest;
import org.ballerinalang.langserver.extensions.ballerina.connector.BallerinaRecordRequest;
import org.ballerinalang.langserver.extensions.ballerina.connector.BallerinaRecordResponse;
import org.ballerinalang.langserver.extensions.ballerina.connector.CentralConnectorListResult;
import org.ballerinalang.langserver.extensions.ballerina.connector.ConnectorExtContext;
import org.ballerinalang.langserver.extensions.ballerina.connector.ConnectorNodeVisitor;
import org.ballerinalang.langserver.extensions.ballerina.connector.LSRecordCache;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;
import org.wso2.ballerinalang.util.RepoUtils;

@JsonSegment(value="ballerinaConnector")
public class BallerinaConnectorService
implements ExtendedLanguageServerService {
    public static final String DEFAULT_CONNECTOR_FILE_KEY = "DEFAULT_CONNECTOR_FILE";
    private String connectorConfig;
    private WorkspaceManager workspaceManager;
    private ConnectorExtContext connectorExtContext;
    private LSClientLogger clientLogger;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.workspaceManager = workspaceManager;
        this.connectorExtContext = new ConnectorExtContext();
        this.connectorConfig = System.getenv(DEFAULT_CONNECTOR_FILE_KEY);
        this.clientLogger = LSClientLogger.getInstance(serverContext);
        if (this.connectorConfig == null) {
            this.connectorConfig = System.getProperty(DEFAULT_CONNECTOR_FILE_KEY);
        }
    }

    @JsonRequest
    public CompletableFuture<BallerinaConnectorListResponse> connectors(BallerinaConnectorListRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaConnectorListResponse connectorList = new BallerinaConnectorListResponse();
            try {
                Settings settings = RepoUtils.readSettings();
                CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
                JsonElement connectorSearchResult = client.getConnectors(request.getQueryMap(), "any", RepoUtils.getBallerinaVersion());
                CentralConnectorListResult centralConnectorListResult = (CentralConnectorListResult)new Gson().fromJson(connectorSearchResult.getAsString(), CentralConnectorListResult.class);
                connectorList.setCentralConnectors(centralConnectorListResult.getConnectors());
                if (request.getTargetFile() != null) {
                    Path filePath = Path.of(request.getTargetFile(), new String[0]);
                    List<Connector> localConnectors = this.fetchLocalConnectors(filePath, false, request.getQuery());
                    connectorList.setLocalConnectors(localConnectors);
                }
            }
            catch (Exception e) {
                String msg = "Operation 'ballerinaConnector/connectors' failed!";
                this.clientLogger.logError(this.connectorExtContext, msg, e, null, new Position[]{null});
            }
            return connectorList;
        });
    }

    private List<Connector> fetchLocalConnectors(Path filePath, boolean detailed, String query) {
        Optional project = this.workspaceManager.project(filePath);
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        if (project.isPresent()) {
            connectors.addAll(ConnectorGenerator.getProjectConnectors((Project)((Project)project.get()), (boolean)detailed, (String)query));
        }
        return connectors;
    }

    private Path resolveBalaPath(String org, String pkgName, String version) throws LSConnectorException {
        Package resolvedPackage;
        Environment environment = EnvironmentBuilder.buildDefault();
        PackageDescriptor packageDescriptor = PackageDescriptor.from((PackageOrg)PackageOrg.from((String)org), (PackageName)PackageName.from((String)pkgName), (PackageVersion)PackageVersion.from((String)version));
        ResolutionRequest resolutionRequest = ResolutionRequest.from((PackageDescriptor)packageDescriptor);
        PackageResolver packageResolver = (PackageResolver)environment.getService(PackageResolver.class);
        Collection resolutionResponses = packageResolver.resolvePackages(Collections.singletonList(resolutionRequest), ResolutionOptions.builder().setOffline(false).build());
        ResolutionResponse resolutionResponse = resolutionResponses.stream().findFirst().orElse(null);
        if (resolutionResponse != null && resolutionResponse.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED) && (resolvedPackage = resolutionResponse.resolvedPackage()) != null) {
            return resolvedPackage.project().sourceRoot();
        }
        throw new LSConnectorException("No bala project found for package '" + packageDescriptor.toString() + "'");
    }

    @JsonRequest
    public CompletableFuture<JsonObject> connector(BallerinaConnectorRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<JsonObject> connector = this.getConnectorFromCentral(request);
            if (connector.isPresent()) {
                return connector.get();
            }
            connector = this.generateFromLocalFiles(request);
            if (connector.isPresent()) {
                return connector.get();
            }
            return new JsonObject();
        });
    }

    private Optional<JsonObject> getConnectorFromCentral(BallerinaConnectorRequest request) {
        try {
            Settings settings = RepoUtils.readSettings();
            CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
            if (request.getConnectorId() != null) {
                JsonObject connector = client.getConnector(request.getConnectorId(), "any", RepoUtils.getBallerinaVersion());
                return Optional.of(connector);
            }
            if (request.isFullConnector()) {
                ConnectorInfo connectorInfo = new ConnectorInfo(request.getOrgName(), request.getPackageName(), request.getModuleName(), request.getVersion(), request.getName());
                JsonObject connector = client.getConnector(connectorInfo, "any", RepoUtils.getBallerinaVersion());
                return Optional.of(connector);
            }
        }
        catch (Exception e) {
            String msg = "Operation 'ballerinaConnector/connector' failed!";
            this.clientLogger.logError(this.connectorExtContext, msg, e, null, new Position[]{null});
        }
        return Optional.empty();
    }

    private Optional<JsonObject> generateFromLocalFiles(BallerinaConnectorRequest request) {
        try {
            Path filePath = request.getTargetFile() != null ? Path.of(request.getTargetFile(), new String[0]) : this.resolveBalaPath(request.getOrgName(), request.getModuleName(), request.getVersion());
            List<Connector> localConnectors = this.fetchLocalConnectors(filePath, true, "");
            for (Connector conn : localConnectors) {
                if (!conn.name.equals(request.getName())) continue;
                Gson gson = new Gson();
                JsonObject connector = (JsonObject)gson.fromJson(gson.toJson((Object)conn), JsonObject.class);
                return Optional.of(connector);
            }
        }
        catch (Exception e) {
            String connectorId = this.getCacheableKey(request.getOrgName(), request.getModuleName(), request.getVersion());
            String msg = "Operation 'ballerinaConnector/connector' for " + connectorId + ":" + request.getName() + " failed!";
            this.clientLogger.logError(this.connectorExtContext, msg, e, null, new Position[]{null});
        }
        return Optional.empty();
    }

    @JsonRequest
    public CompletableFuture<BallerinaRecordResponse> record(BallerinaRecordRequest request) {
        String cacheableKey = this.getCacheableKey(request.getOrg(), request.getModule(), request.getVersion());
        LSRecordCache recordCache = LSRecordCache.getInstance(this.connectorExtContext);
        JsonElement ast = recordCache.getRecordAST(request.getOrg(), request.getModule(), request.getVersion(), request.getName());
        String error = "";
        if (ast == null) {
            try {
                Path balaPath = this.resolveBalaPath(request.getOrg(), request.getModule(), request.getVersion());
                ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
                defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
                Project balaProject = ProjectLoader.loadProject((Path)balaPath, (ProjectEnvironmentBuilder)defaultBuilder);
                ModuleId moduleId = (ModuleId)balaProject.currentPackage().moduleIds().stream().findFirst().get();
                Module module = balaProject.currentPackage().module(moduleId);
                PackageCompilation packageCompilation = balaProject.currentPackage().getCompilation();
                SemanticModel semanticModel = packageCompilation.getSemanticModel(moduleId);
                HashMap<String, JsonElement> recordDefJsonMap = new HashMap<String, JsonElement>();
                ConnectorNodeVisitor connectorNodeVisitor = new ConnectorNodeVisitor(request.getName(), semanticModel);
                module.documentIds().forEach(documentId -> module.document(documentId).syntaxTree().rootNode().accept((NodeVisitor)connectorNodeVisitor));
                TypeDefinitionNode recordNode = null;
                JsonElement recordJson = null;
                for (Map.Entry<String, TypeDefinitionNode> recordEntry : connectorNodeVisitor.getRecords().entrySet()) {
                    String key = recordEntry.getKey();
                    TypeDefinitionNode record = recordEntry.getValue();
                    JsonElement jsonST = DiagramUtil.getTypeDefinitionSyntaxJson((TypeDefinitionNode)record, (SemanticModel)semanticModel);
                    if (record.typeName().text().equals(request.getName())) {
                        recordNode = record;
                        recordJson = jsonST;
                        continue;
                    }
                    recordDefJsonMap.put(key, jsonST);
                }
                Gson gson = new Gson();
                if (recordNode != null) {
                    if (recordJson instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)recordJson;
                        JsonElement recordsJson = gson.toJsonTree(recordDefJsonMap);
                        jsonObject.add("records", recordsJson);
                    }
                    recordCache.addRecordAST(request.getOrg(), request.getModule(), request.getVersion(), request.getName(), recordJson);
                }
                ast = recordCache.getRecordAST(request.getOrg(), request.getModule(), request.getVersion(), request.getName());
            }
            catch (Exception e) {
                String msg = "Operation 'ballerinaConnector/record' for " + cacheableKey + ":" + request.getName() + " failed!";
                error = e.getMessage();
                this.clientLogger.logError(this.connectorExtContext, msg, e, null, new Position[]{null});
            }
        }
        BallerinaRecordResponse response = new BallerinaRecordResponse(request.getOrg(), request.getModule(), request.getVersion(), request.getName(), ast, error, request.getBeta());
        return CompletableFuture.supplyAsync(() -> response);
    }

    private String getCacheableKey(String orgName, String moduleName, String version) {
        return orgName + "_" + moduleName + "_" + (version.isEmpty() ? "0.0.0" : version);
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }
}

