/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextDocuments;
import io.ballerina.tools.text.TextEdit;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.diagramutil.DiagramUtil;
import org.ballerinalang.diagramutil.JSONGenerationException;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.extensions.ballerina.document.ASTModification;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaTreeModifyUtil;
import org.ballerinalang.langserver.extensions.ballerina.document.visitor.FindNodes;
import org.ballerinalang.langserver.extensions.ballerina.document.visitor.UnusedSymbolsVisitor;

public final class BallerinaTriggerModifyUtil {
    private static final String MAIN = "main";
    private static final String SERVICE = "service";
    private static final String SCHEDULE = "SCHEDULE";
    private static final String CURRENT_TRIGGER = "CURRENT_TRIGGER";
    public static final String EMPTY_STRING = "";

    private BallerinaTriggerModifyUtil() {
    }

    public static JsonElement modifyTrigger(String type, JsonObject config, Path compilationPath, WorkspaceManager workspaceManager) throws WorkspaceDocumentException, JSONGenerationException, FormatterException {
        Optional oldSyntaxTree = workspaceManager.syntaxTree(compilationPath);
        boolean isFileEmpty = false;
        if (oldSyntaxTree.isEmpty()) {
            oldSyntaxTree.get();
        }
        TextDocument oldTextDocument = ((SyntaxTree)oldSyntaxTree.get()).textDocument();
        List<TextEdit> edits = BallerinaTriggerModifyUtil.createTriggerEdits(oldTextDocument, (SyntaxTree)oldSyntaxTree.get(), type.toUpperCase(), config);
        TextDocumentChange textDocumentChange = TextDocumentChange.from((TextEdit[])edits.toArray(new TextEdit[0]));
        TextDocument newTextDoc = oldTextDocument.apply(textDocumentChange);
        SyntaxTree updatedSyntaxTree = SyntaxTree.from((TextDocument)newTextDoc);
        SemanticModel updatedSemanticModel = BallerinaTriggerModifyUtil.updateWorkspaceDocument(compilationPath, updatedSyntaxTree.toSourceCode(), workspaceManager);
        Document srcFile = (Document)workspaceManager.document(compilationPath).orElseThrow();
        UnusedSymbolsVisitor unusedSymbolsVisitor = new UnusedSymbolsVisitor(srcFile, updatedSemanticModel, new HashMap<LineRange, ASTModification>());
        unusedSymbolsVisitor.visit((ModulePartNode)updatedSyntaxTree.rootNode());
        if (!unusedSymbolsVisitor.getUnusedImports().isEmpty()) {
            TextDocument updatedTextDocument = TextDocuments.from((String)newTextDoc.toString());
            edits = BallerinaTreeModifyUtil.getUnusedImportRanges(unusedSymbolsVisitor.getUnusedImports(), updatedTextDocument);
            textDocumentChange = TextDocumentChange.from((TextEdit[])edits.toArray(new TextEdit[0]));
            newTextDoc = newTextDoc.apply(textDocumentChange);
        }
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)newTextDoc);
        String formattedSource = Formatter.format((SyntaxTree)syntaxTree).toSourceCode();
        SemanticModel newSemanticModel = BallerinaTriggerModifyUtil.updateWorkspaceDocument(compilationPath, formattedSource, workspaceManager);
        Optional formattedSrcFile = workspaceManager.document(compilationPath);
        if (formattedSrcFile.isEmpty()) {
            throw new JSONGenerationException("Modification error");
        }
        JsonElement syntaxTreeJson = DiagramUtil.getSyntaxTreeJSON((Document)((Document)formattedSrcFile.get()), (SemanticModel)newSemanticModel);
        JsonObject jsonTreeWithSource = new JsonObject();
        jsonTreeWithSource.add("tree", syntaxTreeJson);
        jsonTreeWithSource.addProperty("source", ((Document)formattedSrcFile.get()).syntaxTree().toSourceCode());
        return jsonTreeWithSource;
    }

    private static SemanticModel updateWorkspaceDocument(Path compilationPath, String content, WorkspaceManager workspaceManager) throws WorkspaceDocumentException {
        Optional document = workspaceManager.document(compilationPath);
        if (document.isEmpty()) {
            throw new WorkspaceDocumentException("Document does not exist in path: " + compilationPath.toString());
        }
        Document updatedDoc = ((Document)document.get()).modify().withContent(content).apply();
        return updatedDoc.module().packageInstance().getCompilation().getSemanticModel(updatedDoc.module().moduleId());
    }

    private static List<FunctionDefinitionNode> getResourceFunctions(ServiceDeclarationNode serviceDeclarationNode) {
        ArrayList<FunctionDefinitionNode> resources = new ArrayList<FunctionDefinitionNode>();
        for (Node node : serviceDeclarationNode.members()) {
            FunctionDefinitionNode functionDefinitionNode;
            List<String> qualifiers;
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION || !(qualifiers = (functionDefinitionNode = (FunctionDefinitionNode)node).qualifierList().stream().map(Token::text).toList()).contains(SyntaxKind.RESOURCE_KEYWORD.stringValue())) continue;
            resources.add(functionDefinitionNode);
        }
        return resources;
    }

    private static List<TextEdit> createTriggerEdits(TextDocument oldTextDocument, SyntaxTree oldSyntaxTree, String type, JsonObject config) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Gson gson = new Gson();
        String currentTrigger = EMPTY_STRING;
        if (config != null && config.has(CURRENT_TRIGGER)) {
            currentTrigger = config.get(CURRENT_TRIGGER).getAsString();
        }
        FindNodes findNodes = new FindNodes();
        findNodes.visit((ModulePartNode)oldSyntaxTree.rootNode());
        if (findNodes.getFunctionDefinitionNodes().isEmpty() && findNodes.getServiceDeclarationNodes().isEmpty()) {
            if (MAIN.equalsIgnoreCase(type)) {
                edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "MAIN_START", 1, 1, 1, 1));
                edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "MAIN_END", 1, 1, 1, 1));
            } else if (SERVICE.equalsIgnoreCase(type)) {
                edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, (JsonObject)gson.fromJson("{\"TYPE\":\"ballerina/http\"}", JsonObject.class), "IMPORT", 1, 1, 1, 1));
                edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "SERVICE_START", 1, 1, 1, 1));
                edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "SERVICE_END", 1, 1, 1, 1));
            }
        } else {
            Optional<FunctionDefinitionNode> mainFunction = findNodes.getFunctionDefinitionNodes().stream().filter(function -> function.functionName().text().equals(MAIN)).findFirst();
            if (mainFunction.isPresent()) {
                if (MAIN.equalsIgnoreCase(type)) {
                    Optional<ImportDeclarationNode> httpImport = findNodes.getImportDeclarationNodesList().stream().filter(aImport -> (aImport.orgName().isPresent() ? ((ImportOrgNameNode)aImport.orgName().get()).orgName().text() : EMPTY_STRING).equalsIgnoreCase("ballerina") && aImport.moduleName().size() == 1 && ((IdentifierToken)aImport.moduleName().get(0)).text().equalsIgnoreCase("http")).findFirst();
                    if (httpImport.isEmpty()) {
                        edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, (JsonObject)gson.fromJson("{\"TYPE\":\"ballerina/http\"}", JsonObject.class), "IMPORT", 1, 1, 1, 1));
                    }
                    int startLine = mainFunction.get().lineRange().startLine().line();
                    if (SCHEDULE.equalsIgnoreCase(currentTrigger)) {
                        --startLine;
                    }
                    edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "MAIN_START_MODIFY", startLine, mainFunction.get().lineRange().startLine().offset(), mainFunction.get().functionBody().lineRange().startLine().line(), mainFunction.get().functionBody().lineRange().startLine().offset() + 1));
                } else if (SERVICE.equalsIgnoreCase(type)) {
                    Optional<ImportDeclarationNode> httpImport = findNodes.getImportDeclarationNodesList().stream().filter(aImport -> (aImport.orgName().isPresent() ? ((ImportOrgNameNode)aImport.orgName().get()).orgName().text() : EMPTY_STRING).equalsIgnoreCase("ballerina") && aImport.moduleName().size() == 1 && ((IdentifierToken)aImport.moduleName().get(0)).text().equalsIgnoreCase("http")).findFirst();
                    if (httpImport.isEmpty()) {
                        edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, (JsonObject)gson.fromJson("{\"TYPE\":\"ballerina/http\"}", JsonObject.class), "IMPORT", 1, 1, 1, 1));
                    }
                    int startLine = mainFunction.get().lineRange().startLine().line();
                    if (SCHEDULE.equalsIgnoreCase(currentTrigger)) {
                        --startLine;
                    }
                    edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "SERVICE_START", startLine, mainFunction.get().lineRange().startLine().offset(), mainFunction.get().functionBody().lineRange().startLine().line(), mainFunction.get().functionBody().lineRange().startLine().offset() + 1));
                    edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "SERVICE_END", mainFunction.get().functionBody().lineRange().endLine().line(), mainFunction.get().functionBody().lineRange().endLine().offset() - 1, mainFunction.get().lineRange().endLine().line(), mainFunction.get().lineRange().endLine().offset()));
                }
            } else {
                Optional service = findNodes.getServiceDeclarationNodes().stream().findFirst();
                if (service.isPresent()) {
                    List<FunctionDefinitionNode> resourceFunctions = BallerinaTriggerModifyUtil.getResourceFunctions((ServiceDeclarationNode)service.get());
                    if (MAIN.equalsIgnoreCase(type)) {
                        if (((ServiceDeclarationNode)service.get()).metadata().isPresent() && ((MetadataNode)((ServiceDeclarationNode)service.get()).metadata().get()).annotations() != null && !((MetadataNode)((ServiceDeclarationNode)service.get()).metadata().get()).annotations().isEmpty()) {
                            edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "MAIN_START", ((AnnotationNode)((MetadataNode)((ServiceDeclarationNode)service.get()).metadata().get()).annotations().get(0)).lineRange().startLine().line(), ((AnnotationNode)((MetadataNode)((ServiceDeclarationNode)service.get()).metadata().get()).annotations().get(0)).lineRange().startLine().offset(), resourceFunctions.get(0).functionBody().lineRange().startLine().line(), resourceFunctions.get(0).functionBody().lineRange().startLine().offset() + 1));
                        } else {
                            edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "MAIN_START", ((ServiceDeclarationNode)service.get()).lineRange().startLine().line(), ((ServiceDeclarationNode)service.get()).lineRange().startLine().offset(), resourceFunctions.get(0).functionBody().lineRange().startLine().line(), resourceFunctions.get(0).functionBody().lineRange().startLine().offset() + 1));
                        }
                        edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "MAIN_END", resourceFunctions.get(0).functionBody().lineRange().endLine().line(), resourceFunctions.get(0).functionBody().lineRange().endLine().offset() - 1, ((ServiceDeclarationNode)service.get()).lineRange().endLine().line(), ((ServiceDeclarationNode)service.get()).lineRange().endLine().offset()));
                    } else if (SERVICE.equalsIgnoreCase(type)) {
                        edits.add(BallerinaTreeModifyUtil.createTextEdit(oldTextDocument, config, "SERVICE_START_MODIFY", ((AnnotationNode)((MetadataNode)((ServiceDeclarationNode)service.get()).metadata().get()).annotations().get(0)).lineRange().startLine().line(), ((AnnotationNode)((MetadataNode)((ServiceDeclarationNode)service.get()).metadata().get()).annotations().get(0)).lineRange().startLine().offset(), resourceFunctions.get(0).functionBody().lineRange().startLine().line(), resourceFunctions.get(0).functionBody().lineRange().startLine().offset() + 1));
                    }
                } else {
                    throw new RuntimeException("Trigger function not found for replacement!");
                }
            }
        }
        return edits;
    }
}

