/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AbsResourcePathAttachPoint;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.LiteralAttachPoint;
import io.ballerina.compiler.api.symbols.ServiceAttachPoint;
import io.ballerina.compiler.api.symbols.ServiceAttachPointKind;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Location;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.extensions.ballerina.document.TestCaseVisitor;

public final class ExecutorPositionsUtil {
    static final String FILE_PATH = "filePath";
    static final String KIND = "kind";
    static final String FUNC_MAIN = "main";
    static final String MODULES = "modules";
    static final String GENERATED_MODULES = "generated";
    static final String NAME = "name";
    static final String RANGE = "range";
    static final String SOURCE = "source";
    static final String TEST = "test";
    static final String TEST_CONFIG = "test:Config";
    static final Gson GSON = new Gson();

    private ExecutorPositionsUtil() {
    }

    public static JsonArray getExecutorPositions(WorkspaceManager workspaceManager, Path filePath) {
        JsonArray execPositions = new JsonArray();
        Optional optionalProject = workspaceManager.project(filePath);
        Optional module = workspaceManager.module(filePath);
        if (optionalProject.isEmpty() || module.isEmpty()) {
            return execPositions;
        }
        Project project = (Project)optionalProject.get();
        if (!((Module)module.get()).isDefaultModule()) {
            ExecutorPositionsUtil.getTestCasePositions(execPositions, project, filePath, (Module)module.get());
            return execPositions;
        }
        Optional semanticModel = workspaceManager.semanticModel(filePath);
        if (semanticModel.isEmpty()) {
            return execPositions;
        }
        List symbolList = ((SemanticModel)semanticModel.get()).moduleSymbols();
        List<FunctionSymbol> defaultModuleFunctionList = symbolList.stream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION && symbol.getName().isPresent() && ((String)symbol.getName().get()).equals(FUNC_MAIN) && symbol.getLocation().isPresent()).filter(symbol -> {
            try {
                return ExecutorPositionsUtil.isLocationInFile((Module)module.get(), (Location)symbol.getLocation().get(), filePath);
            }
            catch (IOException e) {
                return false;
            }
        }).map(symbol -> (FunctionSymbol)symbol).toList();
        if (defaultModuleFunctionList.size() == 1) {
            JsonObject mainFunctionObject = new JsonObject();
            mainFunctionObject.addProperty(KIND, SOURCE);
            mainFunctionObject.addProperty(NAME, FUNC_MAIN);
            if (defaultModuleFunctionList.get(0).getLocation().isPresent()) {
                Location location = (Location)defaultModuleFunctionList.get(0).getLocation().get();
                mainFunctionObject.add(RANGE, GSON.toJsonTree((Object)location.lineRange()));
                mainFunctionObject.addProperty(FILE_PATH, location.lineRange().fileName());
            }
            execPositions.add((JsonElement)mainFunctionObject);
        }
        symbolList.stream().filter(symbol -> symbol.kind() == SymbolKind.SERVICE_DECLARATION && symbol.getLocation().isPresent()).filter(symbol -> {
            try {
                return ExecutorPositionsUtil.isLocationInFile((Module)module.get(), (Location)symbol.getLocation().get(), filePath);
            }
            catch (IOException e) {
                return false;
            }
        }).map(symbol -> (ServiceDeclarationSymbol)symbol).toList().forEach(serviceSymbol -> {
            Optional serviceAttachPoint;
            JsonObject serviceObject = new JsonObject();
            serviceObject.addProperty(KIND, SOURCE);
            if (serviceSymbol.getLocation().isPresent()) {
                Location location = (Location)serviceSymbol.getLocation().get();
                serviceObject.add(RANGE, GSON.toJsonTree((Object)location.lineRange()));
                serviceObject.addProperty(FILE_PATH, location.lineRange().fileName());
            }
            if ((serviceAttachPoint = serviceSymbol.attachPoint()).isPresent()) {
                ServiceAttachPointKind kind = ((ServiceAttachPoint)serviceAttachPoint.get()).kind();
                if (kind == ServiceAttachPointKind.ABSOLUTE_RESOURCE_PATH) {
                    List segments = ((AbsResourcePathAttachPoint)serviceAttachPoint.get()).segments();
                    serviceObject.addProperty(NAME, String.join((CharSequence)"_", segments));
                } else if (kind == ServiceAttachPointKind.STRING_LITERAL) {
                    serviceObject.addProperty(NAME, ((LiteralAttachPoint)serviceAttachPoint.get()).literal());
                }
            }
            execPositions.add((JsonElement)serviceObject);
        });
        ExecutorPositionsUtil.getTestCasePositions(execPositions, project, filePath, (Module)module.get());
        return execPositions;
    }

    private static boolean isLocationInFile(Module module, Location location, Path filePath) throws IOException {
        Path symbolPath = PathUtil.getPathFromLocation(module, location);
        return Files.isSameFile(symbolPath, filePath);
    }

    private static void getTestCasePositions(JsonArray execPositions, Project project, Path filePath, Module module) {
        String moduleName = module.moduleName().moduleNamePart() == null ? "" : module.moduleName().moduleNamePart();
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(execPositions, filePath);
        if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            module.documentIds().forEach(documentId -> testCaseVisitor.visitTestCases(module.document(documentId).syntaxTree().rootNode()));
        } else if (project.kind() == ProjectKind.BUILD_PROJECT) {
            module.testDocumentIds().forEach(testDocumentId -> {
                Path testDocPath;
                Document testDocument = module.document(testDocumentId);
                if (module.isDefaultModule()) {
                    testDocPath = project.sourceRoot().resolve(GENERATED_MODULES).resolve(testDocument.name());
                    if (!filePath.endsWith(testDocPath)) {
                        testDocPath = project.sourceRoot().resolve(testDocument.name());
                    }
                } else {
                    testDocPath = project.sourceRoot().resolve(GENERATED_MODULES).resolve(moduleName).resolve(testDocument.name());
                    if (!filePath.endsWith(testDocPath)) {
                        testDocPath = project.sourceRoot().resolve(MODULES).resolve(moduleName).resolve(testDocument.name());
                    }
                }
                try {
                    if (Files.isSameFile(filePath, testDocPath)) {
                        testCaseVisitor.visitTestCases(testDocument.syntaxTree().rootNode());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }
}

